/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.pm.model;

import ch.transsoft.expovit.model.infra.IErrorListener;
import ch.transsoft.expovit.model.infra.event.IChangeListener;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import ch.transsoft.expovit.service.validate.ErrorInfo;
import ch.transsoft.expovit.ui.pm.model.IBooleanPm;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.disposable.Disposables;
import ch.transsoft.expovit.util.disposable.IDisposable;
import javax.swing.JToggleButton;

public class EnabledPm
extends JToggleButton.ToggleButtonModel
implements IDisposable,
IBooleanPm {
    private final NodeBase<?> node;
    private final Disposables disposables = new Disposables();

    public EnabledPm(NodeBase<?> node) {
        Check.assertNotNull(node);
        this.node = node;
        this.setSelected(node.isEnabled());
        this.addPmListener();
        this.disposables.add(node.addChangeListener(this.createNodeListener()));
    }

    @Override
    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    @Override
    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    private IChangeListener createNodeListener() {
        return (source, info) -> this.setSelected(this.node.isEnabled());
    }

    private void addPmListener() {
        this.addChangeListener(e -> this.node.setEnabled(this.isSelected()));
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }
}

