/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.pm.model;

import ch.transsoft.expovit.model.infra.IErrorListener;
import ch.transsoft.expovit.model.infra.event.IChangeListener;
import ch.transsoft.expovit.model.infra.node.StringNodeBase;
import ch.transsoft.expovit.service.validate.ErrorInfo;
import ch.transsoft.expovit.ui.pm.model.IPmListener;
import ch.transsoft.expovit.ui.pm.model.MaxCharsFilter;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.disposable.Disposables;
import ch.transsoft.expovit.util.disposable.IDisposable;
import ch.transsoft.expovit.util.disposable.ListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class StringPm
extends PlainDocument
implements IDisposable {
    private final StringNodeBase<?> node;
    private final Disposables disposables = new Disposables();
    private boolean enabled = true;
    private boolean editable = true;
    private String tooltip;
    private final ListenerList<IPmListener> listeners = new ListenerList();

    public StringPm(StringNodeBase<?> node) {
        this.node = node;
        this.setDocumentFilter(new MaxCharsFilter(node.getMaxLength()));
        this.setText(node.getStringValue());
        this.disposables.add(node.addChangeListener(this.createNodeListener()));
    }

    public void addErrorListener(IErrorListener listener) {
        this.disposables.add(this.node.addErrorListener(listener));
    }

    private IChangeListener createNodeListener() {
        return (source, info) -> this.setText(this.node.getValue());
    }

    private void setText(String string) {
        if (this.node.getValue().equals(this.getText())) {
            return;
        }
        try {
            this.remove(0, this.getLength());
            this.insertString(0, string, null);
        }
        catch (BadLocationException e) {
            Check.fail(e);
        }
    }

    public boolean isMandatory() {
        return this.node.isMandatory();
    }

    public void triggerDataChanged() {
        this.node.setValue(this.getText());
    }

    private String getText() {
        try {
            return this.getText(0, this.getLength());
        }
        catch (BadLocationException e) {
            throw Check.fail(e);
        }
    }

    @Override
    public void dispose() {
        this.disposables.dispose();
    }

    public ErrorInfo getErrorInfo() {
        return this.node.getErrorInfo();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        for (IPmListener listener : this.listeners) {
            listener.enabled(enabled);
        }
    }

    public void setEditableTrue() {
        if (this.editable) {
            return;
        }
        this.editable = true;
        this.tooltip = null;
        this.triggerEditableChanged(null);
    }

    public void setEditableFalse(String reason) {
        if (!this.editable) {
            return;
        }
        this.editable = false;
        this.tooltip = reason;
        this.triggerEditableChanged(reason);
    }

    private void triggerEditableChanged(String reason) {
        for (IPmListener listener : this.listeners) {
            listener.editable(this.editable, reason);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void add(IPmListener listener) {
        this.listeners.add(listener);
    }

    public boolean hasValidator() {
        return this.node.getValidator() != null;
    }

    public boolean isEmpty() {
        return this.getText().isEmpty();
    }
}

