/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.util;

import ch.transsoft.expovit.model.infra.XMLReader;
import ch.transsoft.expovit.model.infra.XMLWriter;
import ch.transsoft.expovit.model.infra.node.IRootNode;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.expovit.util.Check;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileUtil {
    private static final String BACKUP_FILE_NAME = "backup";
    private static final String CORRUPT_FILE_NAME = "corrupt";

    public static void close(Closeable closable) {
        if (closable == null) {
            return;
        }
        try {
            closable.close();
        }
        catch (IOException e) {
            Services.get(ILoggingService.class).logSilent(e, "failed to close handle");
        }
    }

    public static File concat(File seg1, File seg2) {
        return new File(seg1, seg2.getPath());
    }

    public static File addExtension(File target, String ext) {
        if (target.getName().toLowerCase().endsWith("." + ext.toLowerCase())) {
            return target;
        }
        return new File(target.getPath() + "." + ext);
    }

    public static void copy(InputStream input, File destFile) throws IOException {
        FileUtil.copy(input, new FileOutputStream(destFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream input, OutputStream output) throws IOException {
        BufferedInputStream in = new BufferedInputStream(input);
        BufferedOutputStream out = new BufferedOutputStream(output);
        try {
            int c;
            while ((c = ((InputStream)in).read()) != -1) {
                ((OutputStream)out).write(c);
            }
        }
        finally {
            ((OutputStream)out).flush();
            FileUtil.close(out);
            FileUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyWithBuffer(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        finally {
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        destFile.createNewFile();
        FileChannel source = null;
        FileChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            destination.transferFrom(source, 0L, source.size());
        }
        catch (Throwable throwable) {
            FileUtil.close(source);
            FileUtil.close(destination);
            throw throwable;
        }
        FileUtil.close(source);
        FileUtil.close(destination);
    }

    public static File creatTempFile(File source, String name, String ext) {
        File dest = FileUtil.createTempFileName(name, ext);
        try {
            FileUtil.copyFile(source, dest);
        }
        catch (IOException e) {
            Check.fail(e, "copy failed from " + String.valueOf(source) + " to " + String.valueOf(dest));
        }
        return dest;
    }

    public static File creatTempFile(InputStream source, String name, String ext) {
        File dest = FileUtil.createTempFileName(name, ext);
        try {
            FileUtil.copy(source, dest);
        }
        catch (IOException e) {
            Check.fail(e);
        }
        return dest;
    }

    public static File createTempFileName(String name, String ext) {
        File current;
        File current2;
        File tempDir = Services.get(IConfigService.class).getTempDir();
        int i = 0;
        while ((current2 = new File(tempDir, name + i + "." + ext)).exists()) {
            current2.delete();
            ++i;
        }
        int i2 = 0;
        while (true) {
            if (!(current = new File(tempDir, name + i2 + "." + ext)).exists()) break;
            ++i2;
        }
        File dest = current;
        return dest;
    }

    public static List<File> recursiveDelete(File root) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.delete(root, result);
        return result;
    }

    private static void delete(File path, List<File> errors) {
        String[] children2 = path.list();
        if (children2 != null) {
            for (String child : children2) {
                File current = new File(path, child);
                if (current.isDirectory()) {
                    FileUtil.delete(current, errors);
                    continue;
                }
                if (current.delete()) continue;
                errors.add(current);
            }
        }
        if (!path.delete()) {
            errors.add(path);
        }
    }

    public static void recursiveCopy(File source, File dest) throws IOException {
        dest.mkdirs();
        String[] children2 = source.list();
        if (children2 == null) {
            return;
        }
        for (String child : children2) {
            File currentSource = new File(source, child);
            File currentDest = new File(dest, child);
            if (currentSource.isDirectory()) {
                FileUtil.recursiveCopy(currentSource, currentDest);
                continue;
            }
            if (!currentSource.isFile()) continue;
            FileUtil.copyFile(currentSource, currentDest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileAsByteArray(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            int b;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((b = ((InputStream)in).read()) != -1) {
                out.write(b);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            FileUtil.close(in);
        }
    }

    public static boolean isChildSave(File parent, File child) {
        try {
            return FileUtil.isChild(parent, child);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isChild(File parent, File child) throws IOException {
        if (parent.equals(child)) {
            return false;
        }
        String p = parent.getCanonicalPath();
        String c = child.getParentFile().getCanonicalPath();
        return c.startsWith(p);
    }

    public static void writeGZipFile(IRootNode<?> node, File file) throws Exception {
        File backup = FileUtil.getBackupFileName(file);
        File corrupt = FileUtil.getCorruptFileName(file);
        if (file.exists()) {
            file.renameTo(backup);
        }
        XMLWriter xmlWriter = new XMLWriter();
        GZIPOutputStream stream = new GZIPOutputStream(new FileOutputStream(file));
        xmlWriter.write(stream, node);
        backup.delete();
        corrupt.delete();
    }

    public static <T extends IRootNode<T>> T readFile(File pathWithoutExtension, Class<T> type) throws Exception {
        return FileUtil.readFile(pathWithoutExtension.getParentFile(), pathWithoutExtension.getName(), type);
    }

    public static <T extends IRootNode<T>> T readFile(File folder, String fileName, Class<T> type) throws Exception {
        try {
            File gz = new File(folder, fileName + ".xml.gz");
            return FileUtil.readGZipFile(gz, type);
        }
        catch (Exception e) {
            File xml = new File(folder, fileName + ".xml");
            if (xml.exists()) {
                return FileUtil.readXMLFile(xml, type);
            }
            throw e;
        }
    }

    public static <T extends IRootNode<T>> T readGZipFile(File file, Class<T> type) throws Exception {
        File backup = FileUtil.getBackupFileName(file);
        File corrupt = FileUtil.getCorruptFileName(file);
        if (!file.exists()) {
            return FileUtil.internalReadBackup(file, type, backup);
        }
        try {
            return FileUtil.internalReadGZipFile(file, type);
        }
        catch (Exception e) {
            Services.get(ILoggingService.class).logSilent(e, "Failed to read file");
            FileUtil.safeRename(file, corrupt);
            if (backup.exists()) {
                return FileUtil.internalReadGZipFile(backup, type);
            }
            Services.get(ILoggingService.class).logSilentWithBugMail(e, "Failed to read file");
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void safeRename(File oldName, File newName) {
        oldName.renameTo(newName);
    }

    private static <T extends IRootNode<T>> T internalReadBackup(File file, Class<T> type, File backup) throws Exception {
        if (backup.exists()) {
            return FileUtil.internalReadGZipFile(backup, type);
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    public static <T extends IRootNode<T>> T readXMLFile(File file, Class<T> type) throws Exception {
        XMLReader reader = new XMLReader();
        return reader.read(new BufferedInputStream(new FileInputStream(file)), type);
    }

    private static <T extends IRootNode<T>> T internalReadGZipFile(File file, Class<T> type) throws Exception {
        XMLReader reader = new XMLReader();
        return reader.read(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))), type);
    }

    public static File getBackupFileName(File file) {
        return new File(file.getParentFile(), file.getName() + ".backup");
    }

    public static File getCorruptFileName(File file) {
        return new File(file.getParentFile(), file.getName() + ".corrupt");
    }

    public static String getFileNameWithoutExtension(String name) {
        int index = name.lastIndexOf(".");
        if (index < 1) {
            return name;
        }
        return name.substring(0, index);
    }

    public static boolean bestEffortMkdirs(File dir) {
        return dir.mkdirs();
    }
}

