/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.util;

import ch.transsoft.expovit.model.infra.node.INode;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import ch.transsoft.expovit.ui.pm.model.IPm;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.TextUtil;
import ch.transsoft.expovit.util.disposable.IDisposable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ReflectionUtil {
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<String, List<Field>> className2persistableFieldList = new ConcurrentHashMap<String, List<Field>>();

    public static boolean isPersistable(Field field) {
        if (Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        if (Modifier.isTransient(field.getModifiers())) {
            return false;
        }
        field.setAccessible(true);
        return true;
    }

    public static void recursiveDispose(IPm root) {
        try {
            ReflectionUtil.internalDispose(root);
        }
        catch (Exception e) {
            Check.fail(e);
        }
    }

    private static void internalDispose(Object obj) throws IllegalArgumentException, IllegalAccessException {
        if (obj == null) {
            return;
        }
        if (obj instanceof IDisposable) {
            ((IDisposable)obj).dispose();
        }
        if (!(obj instanceof IPm)) {
            return;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            ReflectionUtil.internalDispose(field.get(obj));
        }
    }

    public static void handleChildren(ModelNode<?> parent, NodeHandler handler) {
        for (Field field : parent.getClass().getDeclaredFields()) {
            if (!ReflectionUtil.isPersistable(field)) continue;
            try {
                handler.handle((INode)field.get(parent));
            }
            catch (Exception e) {
                Check.fail(e);
            }
        }
    }

    public static <T extends INode<T>> T getField(ModelNode<?> obj, String fieldName) {
        String methodName = TextUtil.toGetter(fieldName);
        try {
            Method method = obj.getClass().getMethod(methodName, EMPTY_CLASS_ARRAY);
            return (T)((INode)method.invoke(obj, EMPTY_OBJECT_ARRAY));
        }
        catch (ClassCastException e) {
            throw Check.fail("Field " + fieldName + " returned a non-node value", e);
        }
        catch (Exception e) {
            throw Check.fail(e, "method", methodName, "not found on ", obj.getClass().getName());
        }
    }

    public static List<Field> getPersistableFieldListForClass(Class<?> clazz) {
        return className2persistableFieldList.computeIfAbsent(clazz.getName(), k -> Arrays.stream(clazz.getDeclaredFields()).filter(ReflectionUtil::isPersistable).collect(Collectors.toList()));
    }

    public static <T> Class<T> getTypedClassBestEffort(Class<?> aClass) {
        return aClass;
    }

    public static <T> Class<T> getTypedClass(T instance) {
        return instance.getClass();
    }

    public static <T extends NodeBase<T>> Class<T> getTypedFieldTypeBestEffort(Field field) {
        return field.getType();
    }

    public static <T> T newInstanceSafe(Constructor<T> ctor, Object ... args) {
        try {
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface NodeHandler {
        public void handle(INode<?> var1);
    }
}

