/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher;

import ch.transsoft.expovit.util.OsName;
import ch.transsoft.expovit.util.XMLUtil;
import ch.transsoft.launcher.JnlpFileKt;
import ch.transsoft.launcher.JnlpJarNativeLib;
import ch.transsoft.launcher.JnlpJarResource;
import ch.transsoft.launcher.JnlpJre;
import ch.transsoft.launcher.JnlpResource;
import ch.transsoft.launcher.JreAttribute;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010 \u001a\u00020\n*\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u0011*\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lch/transsoft/launcher/JnlpFile;", "", "xml", "Lorg/w3c/dom/Document;", "osName", "Lch/transsoft/expovit/util/OsName;", "<init>", "(Lorg/w3c/dom/Document;Lch/transsoft/expovit/util/OsName;)V", "resources", "", "Lch/transsoft/launcher/JnlpJarResource;", "getResources", "()Ljava/util/List;", "mainJar", "getMainJar", "()Lch/transsoft/launcher/JnlpJarResource;", "nativeLibs", "Lch/transsoft/launcher/JnlpJarNativeLib;", "getNativeLibs", "jre", "Lch/transsoft/launcher/JnlpJre;", "getJre", "()Lch/transsoft/launcher/JnlpJre;", "downloadableResources", "Lkotlin/sequences/Sequence;", "Lch/transsoft/launcher/JnlpResource;", "getDownloadableResources", "()Lkotlin/sequences/Sequence;", "isJreLauncherCommand", "", "node", "Lorg/w3c/dom/Node;", "toJnlpResource", "basePath", "", "toJnlpNativeLib", "Companion", "launcher"})
public final class JnlpFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<JnlpJarResource> resources;
    @NotNull
    private final JnlpJarResource mainJar;
    @NotNull
    private final List<JnlpJarNativeLib> nativeLibs;
    @NotNull
    private final JnlpJre jre;

    public JnlpFile(@NotNull Document xml, @NotNull OsName osName) {
        Intrinsics.checkNotNullParameter(xml, "xml");
        Intrinsics.checkNotNullParameter((Object)osName, "osName");
        String basePath = XMLUtil.getString((Node)xml, "/jnlp/@codebase");
        NodeList resourcesNodes = XMLUtil.findNodes(xml, "/jnlp/resources");
        this.resources = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(JnlpFile._init_$createResourceNodeSequence(resourcesNodes, osName), JnlpFile::_init_$lambda$2), arg_0 -> JnlpFile._init_$lambda$3(this, basePath, arg_0)));
        this.nativeLibs = SequencesKt.toList(SequencesKt.map(SequencesKt.filter(JnlpFile._init_$createResourceNodeSequence(resourcesNodes, osName), JnlpFile::_init_$lambda$4), arg_0 -> JnlpFile._init_$lambda$5(this, basePath, arg_0)));
        this.mainJar = SequencesKt.first(SequencesKt.map(SequencesKt.filter(JnlpFile._init_$createResourceNodeSequence(resourcesNodes, osName), JnlpFile::_init_$lambda$6), arg_0 -> JnlpFile._init_$lambda$7(this, basePath, arg_0)));
        JnlpJre jnlpJre = SequencesKt.firstOrNull(SequencesKt.map(SequencesKt.map(SequencesKt.map(SequencesKt.filter(SequencesKt.filter(JnlpFile._init_$createResourceNodeSequence(resourcesNodes, osName), JnlpFile::_init_$lambda$8), arg_0 -> JnlpFile._init_$lambda$9(this, arg_0)), JnlpFile::_init_$lambda$10), JnlpFile::_init_$lambda$11), arg_0 -> JnlpFile._init_$lambda$12(basePath, arg_0)));
        if (jnlpJre == null) {
            jnlpJre = JnlpJre.Companion.createEmpty();
        }
        this.jre = jnlpJre;
    }

    public /* synthetic */ JnlpFile(Document document, OsName osName, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            OsName osName2 = OsName.getOsName();
            Intrinsics.checkNotNullExpressionValue((Object)osName2, "getOsName(...)");
            osName = osName2;
        }
        this(document, osName);
    }

    @NotNull
    public final List<JnlpJarResource> getResources() {
        return this.resources;
    }

    @NotNull
    public final JnlpJarResource getMainJar() {
        return this.mainJar;
    }

    @NotNull
    public final List<JnlpJarNativeLib> getNativeLibs() {
        return this.nativeLibs;
    }

    @NotNull
    public final JnlpJre getJre() {
        return this.jre;
    }

    @NotNull
    public final Sequence<JnlpResource> getDownloadableResources() {
        return SequencesKt.plus(SequencesKt.plus(CollectionsKt.asSequence((Iterable)this.resources), this.mainJar), (Iterable)this.nativeLibs);
    }

    private final boolean isJreLauncherCommand(Node node) {
        String string = node.getTextContent();
        Intrinsics.checkNotNullExpressionValue(string, "getTextContent(...)");
        return StringsKt.contains$default((CharSequence)string, JreAttribute.LAUNCHER_JRE_VERSION.getCommand(), false, 2, null);
    }

    private final JnlpJarResource toJnlpResource(Node $this$toJnlpResource, String basePath) {
        return new JnlpJarResource(basePath, JnlpFileKt.get($this$toJnlpResource, "href"), JnlpFileKt.get($this$toJnlpResource, "version"));
    }

    private final JnlpJarNativeLib toJnlpNativeLib(Node $this$toJnlpNativeLib, String basePath) {
        return new JnlpJarNativeLib(basePath, JnlpFileKt.get($this$toJnlpNativeLib, "href"), JnlpFileKt.get($this$toJnlpNativeLib, "version"));
    }

    private static final boolean createResourceNodeSequence$lambda$0(OsName $osName, Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = $osName.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale, "getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        string = JnlpFileKt.get(it, "os", string2);
        Locale locale2 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale2, "getDefault(...)");
        String string3 = string.toLowerCase(locale2);
        Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
        string = $osName.name();
        Locale locale3 = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue(locale3, "getDefault(...)");
        Locale locale4 = locale3;
        String string4 = string.toLowerCase(locale4);
        Intrinsics.checkNotNullExpressionValue(string4, "toLowerCase(...)");
        return Intrinsics.areEqual(string3, string4);
    }

    private static final Sequence createResourceNodeSequence$lambda$1(Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return JnlpFileKt.childrenAsSequence(it);
    }

    private static final Sequence<Node> _init_$createResourceNodeSequence(NodeList resourcesNodes, OsName $osName) {
        Intrinsics.checkNotNull(resourcesNodes);
        return SequencesKt.flatMap(SequencesKt.filter(JnlpFileKt.asSequence(resourcesNodes), arg_0 -> JnlpFile.createResourceNodeSequence$lambda$0($osName, arg_0)), JnlpFile::createResourceNodeSequence$lambda$1);
    }

    private static final boolean _init_$lambda$2(Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getLocalName(), "jar") && Intrinsics.areEqual(JnlpFileKt.get(it, "main", "false"), "false");
    }

    private static final JnlpJarResource _init_$lambda$3(JnlpFile this$0, String $basePath, Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNull($basePath);
        return this$0.toJnlpResource(it, $basePath);
    }

    private static final boolean _init_$lambda$4(Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getLocalName(), "nativelib");
    }

    private static final JnlpJarNativeLib _init_$lambda$5(JnlpFile this$0, String $basePath, Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNull($basePath);
        return this$0.toJnlpNativeLib(it, $basePath);
    }

    private static final boolean _init_$lambda$6(Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(JnlpFileKt.get(it, "main"), "true");
    }

    private static final JnlpJarResource _init_$lambda$7(JnlpFile this$0, String $basePath, Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNull($basePath);
        return this$0.toJnlpResource(it, $basePath);
    }

    private static final boolean _init_$lambda$8(Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getNodeType() == 8;
    }

    private static final boolean _init_$lambda$9(JnlpFile this$0, Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.isJreLauncherCommand(it);
    }

    private static final String _init_$lambda$10(Node it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getTextContent();
    }

    private static final Map _init_$lambda$11(String it) {
        Intrinsics.checkNotNull(it);
        return JnlpFileKt.jreCommandParser(it);
    }

    private static final JnlpJre _init_$lambda$12(String $basePath, Map it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Intrinsics.checkNotNull($basePath);
        return new JnlpJre($basePath, it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lch/transsoft/launcher/JnlpFile$Companion;", "", "<init>", "()V", "readJnlpFile", "Lch/transsoft/launcher/JnlpFile;", "jnlpFileLocation", "Ljava/io/File;", "launcher"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JnlpFile readJnlpFile(@NotNull File jnlpFileLocation) {
            Intrinsics.checkNotNullParameter(jnlpFileLocation, "jnlpFileLocation");
            Document document = XMLUtil.read(new FileInputStream(jnlpFileLocation));
            Intrinsics.checkNotNullExpressionValue(document, "read(...)");
            return new JnlpFile(document, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

