/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher;

import ch.transsoft.launcher.JnlpResource;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c2\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lch/transsoft/launcher/JnlpJarResource;", "Lch/transsoft/launcher/JnlpResource;", "basePath", "", "href", "version", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHref", "()Ljava/lang/String;", "fileName", "getFileName", "url", "getUrl", "unzipRequired", "", "getUnzipRequired", "()Z", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "launcher"})
public final class JnlpJarResource
implements JnlpResource {
    @NotNull
    private final String basePath;
    @NotNull
    private final String href;
    @NotNull
    private final String version;
    @NotNull
    private final String fileName;
    private final boolean unzipRequired;

    public JnlpJarResource(@NotNull String basePath, @NotNull String href, @NotNull String version) {
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(href, "href");
        Intrinsics.checkNotNullParameter(version, "version");
        this.basePath = basePath;
        this.href = href;
        this.version = version;
        this.fileName = StringsKt.replace$default(this.href, ".jar", "", false, 4, null) + "__V" + this.version + ".jar";
    }

    @NotNull
    public final String getHref() {
        return this.href;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.basePath + "/" + this.getFileName();
    }

    @Override
    public boolean getUnzipRequired() {
        return this.unzipRequired;
    }

    private final String component1() {
        return this.basePath;
    }

    @NotNull
    public final String component2() {
        return this.href;
    }

    private final String component3() {
        return this.version;
    }

    @NotNull
    public final JnlpJarResource copy(@NotNull String basePath, @NotNull String href, @NotNull String version) {
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(href, "href");
        Intrinsics.checkNotNullParameter(version, "version");
        return new JnlpJarResource(basePath, href, version);
    }

    public static /* synthetic */ JnlpJarResource copy$default(JnlpJarResource jnlpJarResource, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = jnlpJarResource.basePath;
        }
        if ((n & 2) != 0) {
            string2 = jnlpJarResource.href;
        }
        if ((n & 4) != 0) {
            string3 = jnlpJarResource.version;
        }
        return jnlpJarResource.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "JnlpJarResource(basePath=" + this.basePath + ", href=" + this.href + ", version=" + this.version + ")";
    }

    public int hashCode() {
        int result = this.basePath.hashCode();
        result = result * 31 + this.href.hashCode();
        result = result * 31 + this.version.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JnlpJarResource)) {
            return false;
        }
        JnlpJarResource jnlpJarResource = (JnlpJarResource)other;
        if (!Intrinsics.areEqual(this.basePath, jnlpJarResource.basePath)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.href, jnlpJarResource.href)) {
            return false;
        }
        return Intrinsics.areEqual(this.version, jnlpJarResource.version);
    }

    @Override
    @NotNull
    public File toLocalFilePath(@NotNull File targetDir) {
        return JnlpResource.super.toLocalFilePath(targetDir);
    }
}

