/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher;

import ch.transsoft.launcher.JnlpResource;
import ch.transsoft.launcher.JreAttribute;
import ch.transsoft.launcher.util.JavaProperties;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\t\u0010\u001a\u001a\u00020\u0003H\u00c2\u0003J\u0015\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c2\u0003J)\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u0019\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000b\u00a8\u0006$"}, d2={"Lch/transsoft/launcher/JnlpJre;", "Lch/transsoft/launcher/JnlpResource;", "basePath", "", "jreAttributes", "", "Lch/transsoft/launcher/JreAttribute;", "<init>", "(Ljava/lang/String;Ljava/util/Map;)V", "fileName", "getFileName", "()Ljava/lang/String;", "url", "getUrl", "unzipRequired", "", "getUnzipRequired", "()Z", "commandLineArgs", "getCommandLineArgs", "versionString", "kotlin.jvm.PlatformType", "getVersionString", "toLocalFilePath", "Ljava/io/File;", "targetDir", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "launcher"})
public final class JnlpJre
implements JnlpResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String basePath;
    @NotNull
    private final Map<JreAttribute, String> jreAttributes;
    private final boolean unzipRequired;
    private final String versionString;

    public JnlpJre(@NotNull String basePath, @NotNull Map<JreAttribute, String> jreAttributes) {
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(jreAttributes, "jreAttributes");
        this.basePath = basePath;
        this.jreAttributes = jreAttributes;
        String string = this.jreAttributes.get((Object)JreAttribute.LAUNCHER_JRE_VERSION);
        if (string == null) {
            string = JavaProperties.INSTANCE.getJavaVersion();
        }
        this.versionString = string;
    }

    @Override
    @NotNull
    public String getFileName() {
        return "";
    }

    @Override
    @NotNull
    public String getUrl() {
        return "";
    }

    @Override
    public boolean getUnzipRequired() {
        return this.unzipRequired;
    }

    @NotNull
    public final String getCommandLineArgs() {
        String string = this.jreAttributes.get((Object)JreAttribute.COMMAND_LINE_ARGS);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final String getVersionString() {
        return this.versionString;
    }

    @Override
    @NotNull
    public File toLocalFilePath(@NotNull File targetDir) {
        Intrinsics.checkNotNullParameter(targetDir, "targetDir");
        return FilesKt.resolve(FilesKt.resolve(targetDir, "jre"), this.getFileName());
    }

    private final String component1() {
        return this.basePath;
    }

    private final Map<JreAttribute, String> component2() {
        return this.jreAttributes;
    }

    @NotNull
    public final JnlpJre copy(@NotNull String basePath, @NotNull Map<JreAttribute, String> jreAttributes) {
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(jreAttributes, "jreAttributes");
        return new JnlpJre(basePath, jreAttributes);
    }

    public static /* synthetic */ JnlpJre copy$default(JnlpJre jnlpJre, String string, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            string = jnlpJre.basePath;
        }
        if ((n & 2) != 0) {
            map2 = jnlpJre.jreAttributes;
        }
        return jnlpJre.copy(string, map2);
    }

    @NotNull
    public String toString() {
        return "JnlpJre(basePath=" + this.basePath + ", jreAttributes=" + this.jreAttributes + ")";
    }

    public int hashCode() {
        int result = this.basePath.hashCode();
        result = result * 31 + ((Object)this.jreAttributes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JnlpJre)) {
            return false;
        }
        JnlpJre jnlpJre = (JnlpJre)other;
        if (!Intrinsics.areEqual(this.basePath, jnlpJre.basePath)) {
            return false;
        }
        return Intrinsics.areEqual(this.jreAttributes, jnlpJre.jreAttributes);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lch/transsoft/launcher/JnlpJre$Companion;", "", "<init>", "()V", "createEmpty", "Lch/transsoft/launcher/JnlpJre;", "launcher"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JnlpJre createEmpty() {
            return new JnlpJre("", MapsKt.mapOf(TuplesKt.to(JreAttribute.LAUNCHER_JRE_VERSION, "0")));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

