/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher;

import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.expovit.util.SystemUtil;
import ch.transsoft.launcher.MemorySettings;
import ch.transsoft.launcher.configuration.JnlpLaunchConfiguration;
import ch.transsoft.launcher.download.FileResource;
import ch.transsoft.launcher.ui.VersionProvider;
import ch.transsoft.launcher.util.JavaProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\b\u0010\n\u001a\u00020\u000bH\u0002\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"TIMEOUT", "", "launchExpoVit", "", "jnlpLaunchConfiguration", "Lch/transsoft/launcher/configuration/JnlpLaunchConfiguration;", "memorySettings", "Lch/transsoft/launcher/MemorySettings;", "useSystemProxy", "", "getJavaHomeDirectory", "Ljava/io/File;", "extractMainClassFromJar", "", "mainJarResource", "Lch/transsoft/launcher/download/FileResource;", "launcher"})
@SourceDebugExtension(value={"SMAP\nProgramLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProgramLauncher.kt\nch/transsoft/launcher/ProgramLauncherKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,120:1\n37#2:121\n36#2,3:122\n*S KotlinDebug\n*F\n+ 1 ProgramLauncher.kt\nch/transsoft/launcher/ProgramLauncherKt\n*L\n69#1:121\n69#1:122,3\n*E\n"})
public final class ProgramLauncherKt {
    public static final int TIMEOUT = 60000;

    public static final void launchExpoVit(@NotNull JnlpLaunchConfiguration jnlpLaunchConfiguration, @NotNull MemorySettings memorySettings, boolean useSystemProxy) {
        String nativeLibs;
        List<String> jreCommandLineArgs;
        Intrinsics.checkNotNullParameter(jnlpLaunchConfiguration, "jnlpLaunchConfiguration");
        Intrinsics.checkNotNullParameter(memorySettings, "memorySettings");
        String mainClass = ProgramLauncherKt.extractMainClassFromJar(jnlpLaunchConfiguration.getMainJarFile());
        File javaHome = ProgramLauncherKt.getJavaHomeDirectory();
        jnlpLaunchConfiguration.checkJavaVersion();
        String javaFileName = SystemUtil.isOsWindows() ? "java.exe" : "java";
        File javaFile = FilesKt.resolve(javaHome, "bin/" + javaFileName);
        List args = new ArrayList();
        if (!javaFile.exists()) {
            throw new RuntimeException("java.home does not exist");
        }
        String string = javaFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        args.add(string);
        memorySettings.addCommandLineArgs(args);
        args.add("-Dlauncher.version=" + VersionProvider.INSTANCE.getVersion());
        if (useSystemProxy) {
            args.add("-Djava.net.useSystemProxies=true");
        }
        if ((jreCommandLineArgs = jnlpLaunchConfiguration.getJreCommandLineArgs()).isEmpty()) {
            args.addAll((Collection)jreCommandLineArgs);
        }
        if (((CharSequence)(nativeLibs = jnlpLaunchConfiguration.getNativeLibArgument())).length() > 0) {
            args.add("-Djava.library.path=" + nativeLibs);
        }
        args.add("-classpath");
        args.add(jnlpLaunchConfiguration.getClasspath());
        args.add(mainClass);
        String[] stringArray = new String[]{"launch arguments: " + CollectionsKt.joinToString$default(args, " ", null, null, 0, null, null, 62, null)};
        Services.get(ILoggingService.class).logSilent(Level.INFO, stringArray);
        Collection $this$toTypedArray$iv = args;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
        Process process = new ProcessBuilder(new String[0]).command(Arrays.copyOf(stringArray2, stringArray2.length)).redirectErrorStream(true).start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 60000L) {
            String line;
            if (!reader.ready()) {
                Thread.sleep(100L);
                continue;
            }
            if (reader.readLine() == null) break;
            if (!StringsKt.contains$default((CharSequence)line, "ExpoVit UI ready.", false, 2, null)) continue;
            Thread.sleep(1000L);
            break;
        }
    }

    private static final File getJavaHomeDirectory() {
        File jdkFile = new File(JavaProperties.INSTANCE.getJavaHome());
        String[] stringArray = new String[]{"Using Java from: " + jdkFile};
        Services.get(ILoggingService.class).logSilent(Level.INFO, stringArray);
        return jdkFile;
    }

    @NotNull
    public static final String extractMainClassFromJar(@NotNull FileResource mainJarResource) {
        Intrinsics.checkNotNullParameter(mainJarResource, "mainJarResource");
        JarFile jarFile = new JarFile(mainJarResource.getFile());
        String mainClass = jarFile.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
        if (mainClass == null || ((CharSequence)mainClass).length() == 0) {
            return "ch.transsoft.edec.ui.gui.ExpoVit";
        }
        return mainClass;
    }
}

