/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher.download;

import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.expovit.util.SystemUtil;
import java.io.File;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0005J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\u0006\u0010\b\u001a\u00020\u0005R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lch/transsoft/launcher/download/Environment;", "", "<init>", "()V", "workingDirectoryCache", "Ljava/io/File;", "getWorkingDirectory", "getSystemWorkingDir", "getLauncherJarDir", "launcher"})
@SourceDebugExtension(value={"SMAP\nEnvironment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Environment.kt\nch/transsoft/launcher/download/Environment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class Environment {
    @NotNull
    public static final Environment INSTANCE = new Environment();
    @Nullable
    private static File workingDirectoryCache;

    private Environment() {
    }

    @NotNull
    public final File getWorkingDirectory() {
        File file = workingDirectoryCache;
        if (file != null) {
            File it = file;
            boolean bl = false;
            return it;
        }
        String[] stringArray = new String[]{"Current System working Directory: '" + this.getSystemWorkingDir() + "'"};
        Services.get(ILoggingService.class).logSilent(Level.INFO, stringArray);
        String workingDirectoryProperty = System.getProperty("launcher.workingDirectory");
        if (workingDirectoryProperty != null) {
            File result = new File(workingDirectoryProperty);
            String[] stringArray2 = new String[]{"Using system property " + workingDirectoryProperty + " as working dir: " + result.getAbsoluteFile()};
            Services.get(ILoggingService.class).logSilent(Level.INFO, stringArray2);
            return result;
        }
        File userHome = new File(new File(SystemUtil.getUserHomeDir(), ".transsoft"), "expovit");
        Object object = new String[]{"Using user.home/.transsoft as working directory: " + userHome.getAbsoluteFile()};
        Services.get(ILoggingService.class).logSilent(Level.INFO, (String)object);
        Object it = object = userHome;
        boolean bl = false;
        workingDirectoryCache = it;
        return object;
    }

    private final File getSystemWorkingDir() {
        File file = new File("./").getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue(file, "getAbsoluteFile(...)");
        return file;
    }

    @NotNull
    public final File getLauncherJarDir() {
        File file = this.getWorkingDirectory().getParentFile();
        Intrinsics.checkNotNullExpressionValue(file, "getParentFile(...)");
        return FilesKt.resolve(FilesKt.resolve(file, "launcher"), "jars");
    }
}

