/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.channels;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.channels.AbstractChannel;
import kotlinx.coroutines.channels.AbstractChannelKt;
import kotlinx.coroutines.channels.Closed;
import kotlinx.coroutines.channels.ReceiveOrClosed;
import kotlinx.coroutines.channels.Send;
import kotlinx.coroutines.selects.SelectInstance;
import kotlinx.coroutines.selects.SelectKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0015\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010!J!\u0010\"\u001a\u00020\b2\u0006\u0010 \u001a\u00028\u00002\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0014\u00a2\u0006\u0002\u0010%J\n\u0010&\u001a\u0004\u0018\u00010\bH\u0014J\u0016\u0010'\u001a\u0004\u0018\u00010\b2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$H\u0014R\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0012\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lkotlinx/coroutines/channels/ArrayChannel;", "E", "Lkotlinx/coroutines/channels/AbstractChannel;", "capacity", "", "(I)V", "buffer", "", "", "[Ljava/lang/Object;", "bufferDebugString", "", "getBufferDebugString", "()Ljava/lang/String;", "getCapacity", "()I", "head", "isBufferAlwaysEmpty", "", "()Z", "isBufferAlwaysFull", "isBufferEmpty", "isBufferFull", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "Lkotlinx/coroutines/internal/ReentrantLock;", "size", "cleanupSendQueueOnCancel", "", "ensureCapacity", "currentSize", "offerInternal", "element", "(Ljava/lang/Object;)Ljava/lang/Object;", "offerSelectInternal", "select", "Lkotlinx/coroutines/selects/SelectInstance;", "(Ljava/lang/Object;Lkotlinx/coroutines/selects/SelectInstance;)Ljava/lang/Object;", "pollInternal", "pollSelectInternal", "kotlinx-coroutines-core"})
public class ArrayChannel<E>
extends AbstractChannel<E> {
    private final ReentrantLock lock;
    private Object[] buffer;
    private int head;
    private volatile int size;
    private final int capacity;

    @Override
    protected final boolean isBufferAlwaysEmpty() {
        return false;
    }

    @Override
    protected final boolean isBufferEmpty() {
        return this.size == 0;
    }

    @Override
    protected final boolean isBufferAlwaysFull() {
        return false;
    }

    @Override
    protected final boolean isBufferFull() {
        return this.size == this.capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    protected Object offerInternal(E element) {
        int size;
        Object token;
        ReceiveOrClosed<E> receive;
        block13: {
            block15: {
                block16: {
                    Lock lock;
                    block14: {
                        receive = null;
                        token = null;
                        ReentrantLock $this$withLock$iv = this.lock;
                        boolean $i$f$withLock = false;
                        lock = $this$withLock$iv;
                        boolean bl = false;
                        lock.lock();
                        boolean bl2 = false;
                        size = this.size;
                        Closed<?> closed = this.getClosedForSend();
                        if (closed != null) {
                            Closed<?> closed2 = closed;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            Closed<?> it = closed2;
                            boolean bl5 = false;
                            Closed<?> closed3 = it;
                            return closed3;
                        }
                        if (size >= this.capacity) break block14;
                        this.size = size + 1;
                        if (size != 0) break block15;
                        break block16;
                    }
                    Object object = AbstractChannelKt.OFFER_FAILED;
                    return object;
                    finally {
                        lock.unlock();
                    }
                }
                while (this.takeFirstReceiveOrPeekClosed() != null) {
                    if (receive instanceof Closed) {
                        this.size = size;
                        ReceiveOrClosed<E> receiveOrClosed = receive;
                        if (receiveOrClosed == null) {
                            Intrinsics.throwNpe();
                        }
                        ReceiveOrClosed<E> receiveOrClosed2 = receiveOrClosed;
                        return receiveOrClosed2;
                    }
                    ReceiveOrClosed<E> receiveOrClosed = receive;
                    if (receiveOrClosed == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((token = receiveOrClosed.tryResumeReceive(element, null)) == null) continue;
                    break block13;
                }
            }
            this.ensureCapacity(size);
            this.buffer[(this.head + size) % this.buffer.length] = element;
            Object object = AbstractChannelKt.OFFER_SUCCESS;
            return object;
        }
        this.size = size;
        Unit unit = Unit.INSTANCE;
        ReceiveOrClosed<E> receiveOrClosed = receive;
        if (receiveOrClosed == null) {
            Intrinsics.throwNpe();
        }
        receiveOrClosed.completeResumeReceive(token);
        ReceiveOrClosed<E> receiveOrClosed3 = receive;
        if (receiveOrClosed3 != null) return receiveOrClosed3.getOfferResult();
        Intrinsics.throwNpe();
        return receiveOrClosed3.getOfferResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    protected Object offerSelectInternal(E element, @NotNull SelectInstance<?> select) {
        Intrinsics.checkParameterIsNotNull(select, "select");
        receive = null;
        token = null;
        $this$withLock$iv = this.lock;
        $i$f$withLock = false;
        var7_7 = $this$withLock$iv;
        var8_8 = false;
        var7_7.lock();
        try {
            $i$a$-withLock-ArrayChannel$offerSelectInternal$1 = false;
            size = this.size;
            v0 = this.getClosedForSend();
            if (v0 != null) {
                var11_11 = v0;
                var12_13 = false;
                var13_15 = false;
                it = var11_11;
                $i$a$-let-ArrayChannel$offerSelectInternal$1$1 = false;
                var21_22 = it;
                return var21_22;
            }
            if (size >= this.capacity) ** GOTO lbl55
            this.size = size + 1;
            if (size != 0) ** GOTO lbl47
            offerOp = this.describeTryOffer(element);
            failure = select.performAtomicTrySelect(offerOp);
            if (failure == null) {
                this.size = size;
                receive = (ReceiveOrClosed)offerOp.getResult();
                token = offerOp.resumeToken;
                var13_16 = false;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    $i$a$-assert-ArrayChannel$offerSelectInternal$1$2 = false;
                    if (!(token != null)) {
                        throw (Throwable)new AssertionError();
                    }
                }
            } else {
                if (failure != AbstractChannelKt.OFFER_FAILED) {
                    if (failure == SelectKt.getALREADY_SELECTED() || failure instanceof Closed) {
                        this.size = size;
                        var20_23 = failure;
                        return var20_23;
                    }
                    var13_17 = "performAtomicTrySelect(describeTryOffer) returned " + failure;
                    var14_20 = false;
                    throw (Throwable)new IllegalStateException(var13_17.toString());
                }
lbl47:
                // 3 sources

                if (!select.trySelect(null)) {
                    this.size = size;
                    var19_24 = SelectKt.getALREADY_SELECTED();
                    return var19_24;
                }
                this.ensureCapacity(size);
                this.buffer[(this.head + size) % this.buffer.length] = element;
                var18_25 = AbstractChannelKt.OFFER_SUCCESS;
                return var18_25;
lbl55:
                // 1 sources

                var17_26 = AbstractChannelKt.OFFER_FAILED;
                return var17_26;
            }
            var16_27 = Unit.INSTANCE;
        }
        finally {
            var7_7.unlock();
        }
        v1 = receive;
        if (v1 == null) {
            Intrinsics.throwNpe();
        }
        v2 = token;
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        v1.completeResumeReceive(v2);
        v3 = receive;
        if (v3 == null) {
            Intrinsics.throwNpe();
        }
        return v3.getOfferResult();
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureCapacity(int currentSize) {
        if (currentSize >= this.buffer.length) {
            int n = this.buffer.length * 2;
            int n2 = this.capacity;
            int n3 = 0;
            int newSize = Math.min(n, n2);
            Object[] newBuffer = new Object[newSize];
            n2 = 0;
            n3 = currentSize;
            while (n2 < n3) {
                void i;
                newBuffer[i] = this.buffer[(this.head + i) % this.buffer.length];
                ++i;
            }
            this.buffer = newBuffer;
            this.head = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object pollInternal() {
        Send send = null;
        Object token = null;
        Object result = null;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        lock.lock();
        try {
            Object replacement;
            int size;
            block13: {
                boolean bl2 = false;
                size = this.size;
                if (size == 0) {
                    Closed<?> closed = this.getClosedForSend();
                    if (closed == null) {
                        closed = AbstractChannelKt.POLL_FAILED;
                    }
                    Closed<?> closed2 = closed;
                    return closed2;
                }
                result = this.buffer[this.head];
                this.buffer[this.head] = null;
                this.size = size - 1;
                replacement = AbstractChannelKt.POLL_FAILED;
                if (size == this.capacity) {
                    Send send2;
                    do {
                        if (this.takeFirstSendOrPeekClosed() == null) {
                            break block13;
                        }
                        send2 = send;
                        if (send2 != null) continue;
                        Intrinsics.throwNpe();
                    } while ((token = send2.tryResumeSend(null)) == null);
                    Send send3 = send;
                    if (send3 == null) {
                        Intrinsics.throwNpe();
                    }
                    replacement = send3.getPollResult();
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.buffer.length] = replacement;
            }
            this.head = (this.head + 1) % this.buffer.length;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (token != null) {
            Send send4 = send;
            if (send4 == null) {
                Intrinsics.throwNpe();
            }
            send4.completeResumeSend(token);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Object pollSelectInternal(@NotNull SelectInstance<?> select) {
        Intrinsics.checkParameterIsNotNull(select, "select");
        Send send = null;
        Object token = null;
        Object result = null;
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            int size = this.size;
            if (size == 0) {
                Closed<?> closed = this.getClosedForSend();
                if (closed == null) {
                    closed = AbstractChannelKt.POLL_FAILED;
                }
                Closed<?> closed2 = closed;
                return closed2;
            }
            result = this.buffer[this.head];
            this.buffer[this.head] = null;
            this.size = size - 1;
            Object replacement = AbstractChannelKt.POLL_FAILED;
            if (size == this.capacity) {
                AbstractChannel.TryPollDesc pollOp = this.describeTryPoll();
                Object failure = select.performAtomicTrySelect(pollOp);
                if (failure == null) {
                    send = (Send)pollOp.getResult();
                    token = pollOp.resumeToken;
                    boolean bl3 = false;
                    if (DebugKt.getASSERTIONS_ENABLED()) {
                        boolean bl4 = false;
                        if (!(token != null)) {
                            throw (Throwable)((Object)new AssertionError());
                        }
                    }
                    Send send2 = send;
                    if (send2 == null) {
                        Intrinsics.throwNpe();
                    }
                    replacement = send2.getPollResult();
                } else if (failure != AbstractChannelKt.POLL_FAILED) {
                    if (failure == SelectKt.getALREADY_SELECTED()) {
                        this.size = size;
                        this.buffer[this.head] = result;
                        Object object = failure;
                        return object;
                    }
                    if (failure instanceof Closed) {
                        send = (Send)failure;
                        token = ((Closed)failure).tryResumeSend(null);
                        replacement = failure;
                    } else {
                        String string = "performAtomicTrySelect(describeTryOffer) returned " + failure;
                        boolean bl5 = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                }
            }
            if (replacement != AbstractChannelKt.POLL_FAILED && !(replacement instanceof Closed)) {
                this.size = size;
                this.buffer[(this.head + size) % this.buffer.length] = replacement;
            } else if (!select.trySelect(null)) {
                this.size = size;
                this.buffer[this.head] = result;
                Object object = SelectKt.getALREADY_SELECTED();
                return object;
            }
            this.head = (this.head + 1) % this.buffer.length;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (token != null) {
            Send send3 = send;
            if (send3 == null) {
                Intrinsics.throwNpe();
            }
            send3.completeResumeSend(token);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanupSendQueueOnCancel() {
        ReentrantLock $this$withLock$iv = this.lock;
        boolean $i$f$withLock = false;
        Lock lock = $this$withLock$iv;
        boolean bl = false;
        lock.lock();
        try {
            boolean bl2 = false;
            int n = this.size;
            boolean bl3 = false;
            int n2 = 0;
            n2 = 0;
            int n3 = n;
            while (n2 < n3) {
                int it = n2++;
                boolean bl4 = false;
                this.buffer[this.head] = 0;
                this.head = (this.head + 1) % this.buffer.length;
            }
            this.size = 0;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        super.cleanupSendQueueOnCancel();
    }

    @Override
    @NotNull
    protected String getBufferDebugString() {
        return "(buffer:capacity=" + this.capacity + ",size=" + this.size + ')';
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public ArrayChannel(int capacity) {
        this.capacity = capacity;
        int n = this.capacity >= 1 ? 1 : 0;
        int n2 = 0;
        boolean bl = false;
        if (n == 0) {
            boolean bl2 = false;
            String string = "ArrayChannel capacity must be at least 1, but " + this.capacity + " was specified";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.lock = new ReentrantLock();
        n = this.capacity;
        n2 = 8;
        ArrayChannel arrayChannel = this;
        bl = false;
        int n3 = Math.min(n, n2);
        arrayChannel.buffer = new Object[n3];
    }
}

