/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra;

import ch.transsoft.expovit.model.infra.INodeFactory;
import ch.transsoft.expovit.model.infra.LoggingContext;
import ch.transsoft.expovit.model.infra.annotation.decimalSpec;
import ch.transsoft.expovit.model.infra.annotation.defaultValue;
import ch.transsoft.expovit.model.infra.annotation.enumType;
import ch.transsoft.expovit.model.infra.annotation.integralSpec;
import ch.transsoft.expovit.model.infra.annotation.listType;
import ch.transsoft.expovit.model.infra.annotation.mandatory;
import ch.transsoft.expovit.model.infra.annotation.maxlen;
import ch.transsoft.expovit.model.infra.annotation.trimmed;
import ch.transsoft.expovit.model.infra.annotation.validator;
import ch.transsoft.expovit.model.infra.node.BinaryNode;
import ch.transsoft.expovit.model.infra.node.BooleanNode;
import ch.transsoft.expovit.model.infra.node.DateNode;
import ch.transsoft.expovit.model.infra.node.DateTimeNode;
import ch.transsoft.expovit.model.infra.node.DecimalNode;
import ch.transsoft.expovit.model.infra.node.EdecDateNode;
import ch.transsoft.expovit.model.infra.node.EnumNode;
import ch.transsoft.expovit.model.infra.node.FileNode;
import ch.transsoft.expovit.model.infra.node.INode;
import ch.transsoft.expovit.model.infra.node.IStringNodeValidator;
import ch.transsoft.expovit.model.infra.node.IntegralNode;
import ch.transsoft.expovit.model.infra.node.ListEntry;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import ch.transsoft.expovit.model.infra.node.StringNode;
import ch.transsoft.expovit.model.infra.node.TimestampNode;
import ch.transsoft.expovit.model.infra.node.list.ListNodeBase;
import ch.transsoft.expovit.model.infra.nodetypes.NodeTypes;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.DateUtil;
import ch.transsoft.expovit.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class NodeFactory
implements INodeFactory {
    public static <T extends INode<T>> T create(Class<T> type) {
        try {
            return new NodeFactory().createNode(type);
        }
        catch (Exception e) {
            throw Check.fail(e);
        }
    }

    public <T extends INode<T>> T createNode(Class<T> type) throws Exception {
        INode result = (INode)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (result instanceof ModelNode) {
            ModelNode modelNode = (ModelNode)result;
            modelNode.setMandatory(true);
            this.addFields(modelNode);
        }
        return (T)result;
    }

    @Override
    public void addFields(ModelNode<?> parent) throws Exception {
        for (Field field : ReflectionUtil.getPersistableFieldListForClass(parent.getClass())) {
            this.addField(parent, field);
        }
        parent.postConstructionNotification();
    }

    @Override
    public void addField(ModelNode<?> parent, Field field) throws Exception {
        Object obj = NodeTypes.getNodeType(field.getType()).createDefault(parent, this, field);
        if (obj instanceof NodeBase) {
            NodeBase nodeBase = (NodeBase)obj;
            nodeBase.setReadValue(false);
        }
        field.set(parent, obj);
    }

    static boolean isMandatory(Field field) {
        return field.getAnnotation(mandatory.class) != null;
    }

    @Override
    public <T extends ModelNode<T>> T createObject(ModelNode<?> parent, Field field) throws Exception {
        Object result = this.createObject(ReflectionUtil.getTypedFieldTypeBestEffort(field));
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 != null && defaultValue2.equals("enabled")) {
            ((NodeBase)result).setEnabled(true);
        }
        return (T)((ModelNode)this.complete(parent, result, field));
    }

    @Override
    public <T extends ModelNode<T>> T createObject(Class<T> type) throws Exception {
        return (T)((ModelNode)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    private boolean isListType(Class<?> type) {
        return Class.class.equals(type);
    }

    private boolean isInt(Class<?> type) {
        return Integer.class.isAssignableFrom(type) || Integer.TYPE.equals(type);
    }

    private Class<?> getListEntryType(Field field) {
        listType annotation = field.getAnnotation(listType.class);
        Check.assertNotNull(annotation, "missing listType-annotation:", field);
        return annotation.value();
    }

    private Integer getMaxLength(Field field) {
        maxlen maxLenAnnotation = field.getAnnotation(maxlen.class);
        return maxLenAnnotation == null ? null : Integer.valueOf(maxLenAnnotation.value());
    }

    private Object getValueForType(Class<?> paramType, Field field) {
        if (this.isInt(paramType)) {
            return this.getMaxLength(field);
        }
        if (this.isListType(paramType)) {
            return this.getListEntryType(field);
        }
        if (List.class.isAssignableFrom(paramType)) {
            return null;
        }
        throw new RuntimeException("Could not extract value for field " + field.getName() + " with type " + String.valueOf(field.getType()));
    }

    private boolean isJavaUtilList(Class<?> type) {
        return List.class.isAssignableFrom(type);
    }

    public <T extends ListNodeBase<T, E>, E extends ListEntry<E>> T createList(ModelNode<?> parent, Field field) {
        Class<?> fieldType = field.getType();
        List<Constructor> declaredConstructors = Arrays.stream(fieldType.getDeclaredConstructors()).filter(c -> Arrays.stream(c.getParameterTypes()).noneMatch(this::isJavaUtilList)).sorted((a, b) -> Integer.compare(a.getParameterTypes().length, b.getParameterTypes().length) * -1).toList();
        Constructor typedConstructor = declaredConstructors.getFirst();
        Class<?>[] parameterTypes = typedConstructor.getParameterTypes();
        Object[] args = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            args[i] = this.getValueForType(parameterType, field);
        }
        ListNodeBase instance = (ListNodeBase)ReflectionUtil.newInstanceSafe(typedConstructor, args);
        this.complete(parent, instance, field);
        return (T)instance;
    }

    @Override
    public BooleanNode createBoolean(LoggingContext context, ModelNode<?> parent, String value, Field field) {
        BooleanNode result = new BooleanNode();
        this.complete(parent, result, field);
        result.parseValue(context, value);
        return result;
    }

    @Override
    public BooleanNode createDefaultBoolean(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 == null) {
            return this.complete(parent, new BooleanNode(), field);
        }
        return this.createBoolean(new LoggingContext(), parent, defaultValue2, field);
    }

    @Override
    public IntegralNode createDefaultInteger(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 == null) {
            return this.completeInteger(parent, new IntegralNode(null), field);
        }
        return this.createInteger(new LoggingContext(), parent, defaultValue2, field);
    }

    @Override
    public IntegralNode createInteger(LoggingContext context, ModelNode<?> parent, String value, Field field) {
        IntegralNode result = new IntegralNode();
        this.completeInteger(parent, result, field);
        result.parseValue(context, value);
        return result;
    }

    @Override
    public Integer createIntegerPrimitive(String value, Field field) {
        return Integer.parseInt(value);
    }

    @Override
    public Long createLongPrimitive(String str, Field field) {
        return Long.parseLong(str);
    }

    @Override
    public Double createDoublePrimitive(String str, Field field) {
        return Double.parseDouble(str);
    }

    @Override
    public Date createTimestampPrimitive(String str, Field field) {
        return new Date(Long.parseLong(str));
    }

    @Override
    public String createStringPrimitive(String str, Field field) {
        return str;
    }

    @Override
    public Boolean createBooleanPrimitive(String value, Field field) {
        return Boolean.parseBoolean(value);
    }

    @Override
    public DecimalNode createDefaultDecimal(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 == null) {
            return this.internalCreateDecimal(parent, field);
        }
        return this.createDecimal(new LoggingContext(), parent, defaultValue2, field);
    }

    @Override
    public DecimalNode createDecimal(LoggingContext context, ModelNode<?> parent, String value, Field field) {
        DecimalNode result = this.internalCreateDecimal(parent, field);
        result.parseValue(context, value);
        return result;
    }

    private DecimalNode internalCreateDecimal(ModelNode<?> parent, Field field) {
        decimalSpec digits = NodeFactory.getAnnotation(field, decimalSpec.class);
        DecimalNode result = new DecimalNode(digits.fractionDigits());
        return this.complete(parent, result, field);
    }

    @Override
    public StringNode createDefaultString(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        defaultValue2 = defaultValue2 == null ? "" : defaultValue2;
        return this.createString(new LoggingContext(), parent, defaultValue2, field);
    }

    @Override
    public StringNode createString(LoggingContext context, ModelNode<?> parent, String value, Field field) {
        Check.assertNotNull(value);
        int maxlen2 = this.getMaxLen(field);
        StringNode result = new StringNode(maxlen2);
        result.setValidator(this.getValidation(field));
        result.setTrimmed(this.getTrimmed(field));
        this.complete(parent, result, field);
        result.parseValue(context, value);
        return result;
    }

    @Override
    public BinaryNode createBinary(LoggingContext context, ModelNode<?> parent, String value, Field field) {
        Check.assertNotNull(value);
        BinaryNode result = new BinaryNode(value);
        this.complete(parent, result, field);
        return result;
    }

    private int getMaxLen(Field field) {
        maxlen anno = field.getAnnotation(maxlen.class);
        if (anno == null) {
            return Integer.MAX_VALUE;
        }
        return anno.value();
    }

    private IStringNodeValidator getValidation(Field field) {
        validator annotation = field.getAnnotation(validator.class);
        try {
            return annotation == null ? null : annotation.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw Check.fail(e, "validation could not be loaded for field", field);
        }
    }

    private boolean getTrimmed(Field field) {
        return field.getAnnotation(trimmed.class) != null;
    }

    private static <T extends Enum<T>> Class<T> getEnumType(Field field) {
        enumType annotation = NodeFactory.getAnnotation(field, enumType.class);
        return ReflectionUtil.getTypedClassBestEffort(annotation.value());
    }

    @Override
    public <T extends Enum<T>> EnumNode<T> createEnum(String value, Field field, ModelNode<?> parent) {
        try {
            T enumValue = Enum.valueOf(NodeFactory.getEnumType(field), value);
            return this.complete(parent, new EnumNode<T>(enumValue), field);
        }
        catch (IllegalArgumentException e) {
            throw Check.fail(e, "enum constant", value, "not found on field", field);
        }
    }

    @Override
    public Enum<?> createEnumPrimitive(String value, Field field, ModelNode<?> parent) {
        try {
            Class<Enum> enumType2 = field.getType().asSubclass(Enum.class);
            return Enum.valueOf(enumType2, value);
        }
        catch (IllegalArgumentException e) {
            throw Check.fail(e, "enum constant", value, "not found on field", field);
        }
    }

    private String getDefaultValue(Field field) {
        defaultValue annotation = field.getAnnotation(defaultValue.class);
        return annotation == null ? null : annotation.value();
    }

    @Override
    public DateNode createDate(LoggingContext context, ModelNode<?> parent, String date, Field field) {
        DateNode result = new DateNode();
        this.complete(parent, result, field);
        result.parseValue(context, date);
        return result;
    }

    @Override
    public DateTimeNode createDateTime(LoggingContext context, ModelNode<?> parent, String date, Field field) {
        DateTimeNode result = new DateTimeNode();
        this.complete(parent, result, field);
        result.parseValue(context, date);
        return result;
    }

    @Override
    public EdecDateNode createEdecDate(LoggingContext context, ModelNode<?> parent, String date, Field field) {
        EdecDateNode result = new EdecDateNode();
        this.complete(parent, result, field);
        result.parseValue(context, date);
        return result;
    }

    @Override
    public DateNode createDefaultDate(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 == null) {
            return this.complete(parent, new DateNode(), field);
        }
        Date value = defaultValue2.equals("now") ? new Date() : DateUtil.getDate(defaultValue2);
        return this.complete(parent, new DateNode(value), field);
    }

    @Override
    public DateTimeNode createDefaultDateTime(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 == null) {
            return this.complete(parent, new DateTimeNode(), field);
        }
        Date value = defaultValue2.equals("now") ? new Date() : DateUtil.getDateTime(defaultValue2);
        return this.complete(parent, new DateTimeNode(value), field);
    }

    @Override
    public EdecDateNode createDefaultEdecDate(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 == null) {
            return this.complete(parent, new EdecDateNode(), field);
        }
        Check.assertTrue(DateUtil.isEdecDate(defaultValue2), "Wrong date format (yyyy-MM-dd expected): " + defaultValue2);
        return this.complete(parent, new EdecDateNode(defaultValue2), field);
    }

    @Override
    public TimestampNode createTimestamp(LoggingContext context, ModelNode<?> parent, String date, Field field) {
        TimestampNode result = new TimestampNode();
        this.complete(parent, result, field);
        result.parseValue(context, date);
        return result;
    }

    @Override
    public TimestampNode createDefaultTimestamp(ModelNode<?> parent, Field field) {
        String defaultValue2 = this.getDefaultValue(field);
        if (defaultValue2 == null) {
            return this.complete(parent, new TimestampNode(null), field);
        }
        if (defaultValue2.equals("now")) {
            return this.complete(parent, new TimestampNode(new Date()), field);
        }
        throw Check.fail("unexpected default value for timestamp:", defaultValue2);
    }

    @Override
    public FileNode createFile(LoggingContext context, ModelNode<?> parent, String value, Field field) {
        FileNode result = new FileNode();
        this.complete(parent, result, field);
        result.parseValue(context, value);
        return result;
    }

    private IntegralNode completeInteger(ModelNode<?> parent, IntegralNode node, Field field) {
        integralSpec integralSpec2 = field.getAnnotation(integralSpec.class);
        if (integralSpec2 != null) {
            node.setMaxNumberOfDigits(integralSpec2.digits());
        } else {
            node.setMaxNumberOfDigits(Integer.MAX_VALUE);
        }
        return this.complete(parent, node, field);
    }

    private static <T extends Annotation> T getAnnotation(Field field, Class<T> klass) {
        T result = field.getAnnotation(klass);
        Check.assertNotNull(result, "missing annotation", klass, "on field", field);
        return result;
    }

    private <T extends NodeBase<T>> T complete(ModelNode<?> parent, T node, Field field) {
        Check.assertNotNull(parent);
        node.setMandatory(NodeFactory.isMandatory(field));
        node.setFieldName(field.getName());
        node.setParent(parent);
        return node;
    }
}

