/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra;

import ch.transsoft.expovit.model.infra.IXMLWriter;
import ch.transsoft.expovit.model.infra.node.INode;
import ch.transsoft.expovit.model.infra.node.IRootNode;
import ch.transsoft.expovit.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.helpers.DefaultHandler;

public class XMLWriter
implements IXMLWriter {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private Document dom;

    public void write(File path, IRootNode<?> obj, boolean createBackup) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.serialize(buffer, obj);
        if (buffer.size() == 0) {
            return;
        }
        if (createBackup) {
            this.createBackupBestEffort(path);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(buffer.toByteArray());
        FileOutputStream output = new FileOutputStream(path);
        FileUtil.copy((InputStream)input, output);
    }

    private void createBackupBestEffort(File path) {
        if (!path.exists() || path.length() == 0L || !this.fileIsValid(path)) {
            return;
        }
        File backupFile = FileUtil.addExtension(path, "backup");
        try {
            if (path.exists()) {
                FileUtil.copyFile(path, backupFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean fileIsValid(File path) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(path, new DefaultHandler());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void write(OutputStream output, IRootNode<?> obj) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.serialize(buffer, obj);
        FileUtil.copy((InputStream)new ByteArrayInputStream(buffer.toByteArray()), output);
    }

    private void serialize(OutputStream output, IRootNode<?> obj) throws Exception, TransformerFactoryConfigurationError {
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.dom = db.newDocument();
        obj.printField(this.dom, this, obj.getClass().getSimpleName());
        ((Element)this.dom.getFirstChild()).setAttribute("schemaVersion", Integer.toString(obj.getSchemaVersion()));
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.transform(new DOMSource(this.dom), new StreamResult(output));
    }

    @Override
    public void setEnabled(Element element, INode<?> node) {
        if (!node.isMandatory()) {
            element.setAttribute("enabled", Boolean.valueOf(node.isEnabled()).toString());
        }
    }

    @Override
    public Element createElement(Node parent, String name) {
        Element element = this.dom.createElement(name);
        parent.appendChild(element);
        return element;
    }

    @Override
    public void createCDATAChild(Node parent, String value) {
        parent.appendChild(this.dom.createCDATASection(value));
    }

    @Override
    public void appendTextNode(Node parent, String tagName, String value) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(value);
    }

    @Override
    public void printNonNodeField(Node parent, Object obj, String tagName) {
        if (obj == null) {
            return;
        }
        Element node = this.createElement(parent, tagName);
        if (obj instanceof Date) {
            Date date = (Date)obj;
            node.setTextContent(Long.toString(date.getTime()));
        } else {
            node.setTextContent(obj.toString());
        }
    }

    @Override
    public void printPrimitive(Node parent, boolean value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(Boolean.toString(value));
    }

    @Override
    public void printPrimitive(Node parent, byte value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(Byte.toString(value));
    }

    @Override
    public void printPrimitive(Node parent, char value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(Character.toString(value));
    }

    @Override
    public void printPrimitive(Node parent, int value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(Integer.toString(value));
    }

    @Override
    public void printPrimitive(Node parent, long value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(Long.toString(value));
    }

    @Override
    public void printPrimitive(Node parent, float value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(Float.toString(value));
    }

    @Override
    public void printPrimitive(Node parent, double value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(Double.toString(value));
    }

    @Override
    public void printPrimitive(Node parent, Enum<?> value, String tagName) {
        Element node = this.createElement(parent, tagName);
        node.setTextContent(value.name());
    }
}

