/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.LoggingContext;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.PrimitiveBase;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.DateUtil;
import java.text.ParseException;
import java.util.Date;
import javax.xml.datatype.XMLGregorianCalendar;

public final class DateNode
extends PrimitiveBase<DateNode> {
    private Date value;

    public DateNode() {
        this(null);
    }

    public DateNode(Date date) {
        this.value = date;
    }

    @Override
    String getXmlValueString() {
        return DateUtil.formatEzvDate(this.getValue());
    }

    public void setValue(Date value) {
        this.setValue(value, true);
    }

    public void setValue(Date value, boolean dirty) {
        if (this.isSameValue(this.value, value)) {
            return;
        }
        this.value = value;
        this.fireEvent(dirty);
    }

    @Override
    public boolean isInitialized() {
        return this.value != null;
    }

    @Override
    public Date getValue() {
        return this.value;
    }

    public String getDateAsString() {
        return DateUtil.formatEzvDate(this.value);
    }

    @Override
    public DateNode getCopy(ModelNode<?> parent) {
        DateNode result = new DateNode(this.value);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEqual(DateNode other) {
        return this.isSameValue(this.value, other.value);
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        return DateUtil.getDateFormat().format(this.value);
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        if (str.isEmpty()) {
            return;
        }
        if (!DateUtil.isEdecDate(str)) {
            context.log(this.getPath() + Services.getText("606") + " " + str);
            return;
        }
        this.setValue(DateUtil.getDate(str), true);
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        if (value == null) {
            this.setValue(null, dirty);
            return;
        }
        if (value instanceof Date) {
            this.setValue((Date)value, dirty);
            return;
        }
        String str = (String)value;
        try {
            this.setValue((Date)DateUtil.getDateFormat().parseObject(str), dirty);
        }
        catch (ParseException e) {
            this.setValue(null, dirty);
        }
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null, true);
    }

    public XMLGregorianCalendar asXmlGregorianCalendar() {
        Check.assertTrue(this.isInitialized(), "date not initialized");
        return DateUtil.toXmlGregorianCalendar(this.value);
    }

    @Override
    public void cumulate(DateNode other) {
    }
}

