/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.LoggingContext;
import ch.transsoft.expovit.model.infra.node.ModelNode;
import ch.transsoft.expovit.model.infra.node.PrimitiveBase;
import java.io.File;

public final class FileNode
extends PrimitiveBase<FileNode> {
    private File value;

    public FileNode() {
        this(null);
    }

    public FileNode(File file) {
        this.value = file;
    }

    @Override
    String getXmlValueString() {
        return this.getStringValue();
    }

    @Override
    public void parseValue(LoggingContext context, String str) {
        this.setValue(new File(str));
    }

    public void setValue(File value) {
        this.setValue(value, true);
    }

    public void setValue(File value, boolean dirty) {
        if (this.isSameValue(this.value, value)) {
            return;
        }
        this.value = value;
        this.fireEvent(dirty);
    }

    @Override
    public void setValue(Object value, boolean dirty) {
        this.setValue((File)value, dirty);
    }

    @Override
    public boolean isInitialized() {
        return this.value != null;
    }

    @Override
    public File getValue() {
        return this.value;
    }

    public File getValueSave() {
        if (this.isInitialized()) {
            return this.value;
        }
        return new File("");
    }

    @Override
    public FileNode getCopy(ModelNode<?> parent) {
        FileNode result = new FileNode(this.value);
        super.completeCopy(result, parent);
        return result;
    }

    @Override
    public boolean isEqual(FileNode other) {
        return this.isSameValue(this.value, other.value);
    }

    @Override
    public String getStringValue() {
        if (!this.isInitialized()) {
            return "";
        }
        return this.value.getPath();
    }

    public String toString() {
        return this.getStringValue();
    }

    @Override
    public void traverse(ITraversal traversal) {
        traversal.visit(this);
    }

    @Override
    public void clear() {
        this.setValue(null);
    }

    @Override
    public void cumulate(FileNode other) {
    }
}

