/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.model.infra.node;

import ch.transsoft.expovit.model.infra.ITraversal;
import ch.transsoft.expovit.model.infra.IXMLWriter;
import ch.transsoft.expovit.model.infra.InjectionSpec;
import ch.transsoft.expovit.model.infra.node.INode;
import ch.transsoft.expovit.model.infra.node.IntegralNode;
import ch.transsoft.expovit.model.infra.node.ListEntry;
import ch.transsoft.expovit.model.infra.node.NodeBase;
import ch.transsoft.expovit.model.infra.node.StringNodeBase;
import ch.transsoft.expovit.model.infra.node.list.ListNode;
import ch.transsoft.expovit.util.Check;
import ch.transsoft.expovit.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class ModelNode<T extends ModelNode<T>>
extends NodeBase<T> {
    private static final Pattern LIST_QUALIFIER = Pattern.compile("(.*)\\[(\\d*)]");

    @Override
    public void printField(Node node, IXMLWriter writer, String tagName) throws Exception {
        Element element = this.printModelNode(node, writer, tagName);
        this.printFields(element, writer);
    }

    protected Element printModelNode(Node node, IXMLWriter writer, String tagName) {
        Element element = writer.createElement(node, tagName);
        writer.setEnabled(element, this);
        return element;
    }

    protected void printFields(Node parent, IXMLWriter writer) throws Exception {
        List<Field> persistableFieldList = ReflectionUtil.getPersistableFieldListForClass(this.getClass());
        for (Field field : persistableFieldList) {
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            if (fieldType == Boolean.TYPE) {
                writer.printPrimitive(parent, field.getBoolean(this), fieldName);
                continue;
            }
            if (fieldType == Byte.TYPE) {
                writer.printPrimitive(parent, field.getByte(this), fieldName);
                continue;
            }
            if (fieldType == Character.TYPE) {
                writer.printPrimitive(parent, field.getChar(this), fieldName);
                continue;
            }
            if (fieldType == Integer.TYPE) {
                writer.printPrimitive(parent, field.getInt(this), fieldName);
                continue;
            }
            if (fieldType == Long.TYPE) {
                writer.printPrimitive(parent, field.getLong(this), fieldName);
                continue;
            }
            if (fieldType == Float.TYPE) {
                writer.printPrimitive(parent, field.getFloat(this), fieldName);
                continue;
            }
            if (fieldType == Double.TYPE) {
                writer.printPrimitive(parent, field.getDouble(this), fieldName);
                continue;
            }
            if (Enum.class.isAssignableFrom(fieldType)) {
                writer.printPrimitive(parent, (Enum)field.get(this), fieldName);
                continue;
            }
            Object obj = field.get(this);
            if (obj == null) continue;
            if (obj instanceof INode) {
                INode node = (INode)obj;
                node.printField(parent, writer, fieldName);
                continue;
            }
            writer.printNonNodeField(parent, obj, fieldName);
        }
    }

    public IntegralNode findIntegral(String xpath) {
        return (IntegralNode)this.find(xpath);
    }

    public StringNodeBase<?> findString(String xpath) {
        return (StringNodeBase)this.find(xpath);
    }

    public INode<?> find(String xpath) {
        Check.assertNotNull(xpath);
        Check.assertFalse(xpath.isEmpty(), "empty path");
        String[] path = xpath.split("/");
        return this.find(path, 0);
    }

    public List<INode<?>> findAll(String xpath) {
        Check.assertNotNull(xpath);
        if (xpath.isEmpty()) {
            return new ArrayList();
        }
        String[] path = xpath.split("/");
        ArrayList result = new ArrayList();
        this.findAll(path, 0, result);
        return result;
    }

    public void findAll(String[] path, int index, ArrayList<INode<?>> result) {
        Object match = ReflectionUtil.getField(this, path[index]);
        this.findNextAll(path, index, (INode<?>)match, result);
    }

    private void findNextAll(String[] path, int index, INode<?> match, ArrayList<INode<?>> result) {
        if (index == path.length - 1) {
            result.add(match);
            return;
        }
        if (match instanceof ListNode) {
            for (ListEntry current : (ListNode)match) {
                current.findAll(path, index + 1, result);
            }
            return;
        }
        ((ModelNode)match).findAll(path, index + 1, result);
    }

    private INode<?> find(String[] path, int index) {
        Matcher matcher = LIST_QUALIFIER.matcher(path[index]);
        if (matcher.matches()) {
            return this.findListElement(path, index, matcher.group(1), Integer.parseInt(matcher.group(2)));
        }
        Object match = ReflectionUtil.getField(this, path[index]);
        return this.findNext(path, index, (INode<?>)match);
    }

    private INode<?> findNext(String[] path, int index, INode<?> match) {
        if (index == path.length - 1) {
            return match;
        }
        return ((ModelNode)match).find(path, index + 1);
    }

    private INode<?> findListElement(String[] path, int index, String fieldName, int pos) {
        ListNode list = (ListNode)ReflectionUtil.getField(this, fieldName);
        if (pos >= list.size()) {
            return null;
        }
        if (index == path.length - 1) {
            return list.get(pos);
        }
        return this.findNext(path, index, (INode<?>)list.get(pos));
    }

    private boolean isFieldOfNodeType(Field field) {
        return INode.class.isAssignableFrom(field.getType());
    }

    @Override
    public T getCopy(ModelNode<?> parent) {
        T result = this.createInstance();
        for (Field field : this.getPersistableFieldList()) {
            if (this.isFieldOfNodeType(field)) {
                this.setCopyOfField(result, field);
                continue;
            }
            this.setCopyOfNonNodeField(result, field);
        }
        this.completeCopy((NodeBase<?>)result, parent);
        ((NodeBase)result).postConstructionNotification();
        return result;
    }

    private void setCopyOfField(T obj, Field field) {
        try {
            field.set(obj, this.getNode(field, this).getCopy((ModelNode<?>)obj));
        }
        catch (Exception e) {
            Check.fail(e, "Failed to copy field " + String.valueOf(field));
        }
    }

    private void setCopyOfNonNodeField(T obj, Field field) {
        try {
            field.set(obj, field.get(this));
        }
        catch (Exception e) {
            Check.fail(e, "Failed to copy primitive field " + String.valueOf(field));
        }
    }

    private T createInstance() {
        try {
            Class<?> aClass = this.getClass();
            return (T)((ModelNode)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw Check.fail(e);
        }
    }

    @Override
    public void apply(T other) {
        for (Field field : this.getPersistableFieldList()) {
            if (this.isFieldOfNodeType(field)) {
                this.getNode(field, this).apply(this.getNode(field, (ModelNode<?>)other));
                continue;
            }
            try {
                field.set(this, field.get(other));
            }
            catch (Exception e) {
                Check.fail(e, "Failed to apply primitive field " + String.valueOf(field));
            }
        }
    }

    @Override
    public boolean isEqual(T other) {
        for (Field field : this.getPersistableFieldList()) {
            if (this.isFieldOfNodeType(field)) {
                if (this.getNode(field, (ModelNode<?>)other).isEqual(this.getNode(field, this))) continue;
                return false;
            }
            try {
                if (this.primitiveEquals(field.get(this), field.get(other))) continue;
                return false;
            }
            catch (Exception e) {
                Check.fail(e, "Failed to check equality for field " + String.valueOf(field));
            }
        }
        return this.isEnabled() == ((NodeBase)other).isEnabled();
    }

    private <E> boolean primitiveEquals(E fieldA, E fieldB) {
        if (fieldA == fieldB) {
            return true;
        }
        if (fieldA == null) {
            return false;
        }
        return fieldA.equals(fieldB);
    }

    @Override
    public void traverse(ITraversal traversal) {
        if (!traversal.visitChildren(this)) {
            return;
        }
        for (Field field : this.getPersistableFieldList()) {
            if (!this.isFieldOfNodeType(field)) continue;
            this.getNode(field, this).traverse(traversal);
        }
    }

    private <E extends INode<E>> E getNode(Field field, ModelNode<?> parent) {
        if (!this.isFieldOfNodeType(field)) {
            throw new IllegalArgumentException("Field must be of type INode: " + String.valueOf(field));
        }
        try {
            INode result = (INode)field.get(parent);
            return (E)result;
        }
        catch (Exception e) {
            throw Check.fail(e);
        }
    }

    @Override
    public void cumulate(T other) {
        if (((NodeBase)other).isEnabled()) {
            this.setEnabled(((NodeBase)other).isEnabled());
        }
        for (Field field : this.getPersistableFieldList()) {
            if (!this.isFieldOfNodeType(field)) continue;
            this.getNode(field, this).cumulate(this.getNode(field, (ModelNode<?>)other));
        }
    }

    @Override
    public void inject(T other, InjectionSpec spec) {
        if (spec.useUninitialized() || ((NodeBase)other).isEnabled()) {
            this.setEnabled(((NodeBase)other).isEnabled());
        }
        for (Field field : this.getPersistableFieldList()) {
            if (!this.isFieldOfNodeType(field)) continue;
            this.getNode(field, this).inject(this.getNode(field, (ModelNode<?>)other), spec);
        }
    }

    private List<Field> getPersistableFieldList() {
        return ReflectionUtil.getPersistableFieldListForClass(this.getClass());
    }
}

