/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service;

import ch.transsoft.expovit.service.ServiceFactory;
import ch.transsoft.expovit.service.app.AppService;
import ch.transsoft.expovit.service.app.IAppService;
import ch.transsoft.expovit.service.backend.BackendService;
import ch.transsoft.expovit.service.backend.IBackendService;
import ch.transsoft.expovit.service.config.ConfigService;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.gui.GuiService;
import ch.transsoft.expovit.service.gui.IGuiService;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.expovit.service.logging.LoggingService;
import ch.transsoft.expovit.service.masterdata.DataService;
import ch.transsoft.expovit.service.masterdata.IDataService;
import ch.transsoft.expovit.service.proxy.ConnectionService;
import ch.transsoft.expovit.service.proxy.IConnectionService;
import ch.transsoft.expovit.service.text.ITextService;
import ch.transsoft.expovit.service.text.internal.TextService;
import org.jetbrains.annotations.PropertyKey;

public class Services {
    private static final ServiceFactory factory = new ServiceFactory();

    private static synchronized <T> void add(Class<? super T> serviceInterface, Class<T> implementation) {
        factory.add(serviceInterface, implementation);
    }

    public static synchronized <T> T get(Class<T> serviceInterface) {
        return factory.getService(serviceInterface);
    }

    public static String getText(@PropertyKey(resourceBundle="ch.transsoft.expovit.service.text.translation") String key) {
        return Services.get(ITextService.class).getText(key);
    }

    public static String format(@PropertyKey(resourceBundle="ch.transsoft.expovit.service.text.translation") String formatKey, @PropertyKey(resourceBundle="ch.transsoft.expovit.service.text.translation") String textKey) {
        return Services.formatStringArgs(formatKey, Services.getText(textKey));
    }

    public static String formatStringArgs(@PropertyKey(resourceBundle="ch.transsoft.expovit.service.text.translation") String formatKey, Object ... args) {
        return String.format(Services.getText(formatKey), args);
    }

    static {
        Services.add(IBackendService.class, BackendService.class);
        Services.add(ILoggingService.class, LoggingService.class);
        Services.add(ITextService.class, TextService.class);
        Services.add(IDataService.class, DataService.class);
        Services.add(IConfigService.class, ConfigService.class);
        Services.add(IAppService.class, AppService.class);
        Services.add(IGuiService.class, GuiService.class);
        Services.add(IConnectionService.class, ConnectionService.class);
    }
}

