/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.backend;

import ch.transsoft.expovit.model.infra.XMLWriter;
import ch.transsoft.expovit.model.masterdata.IDataNode;
import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.backend.IBackendJob;
import ch.transsoft.expovit.service.backend.jobs.JobUtil;
import ch.transsoft.expovit.service.config.IConfigService;
import ch.transsoft.expovit.service.logging.ILoggingService;
import java.io.File;

public abstract class BackendJobBase
implements IBackendJob {
    private final File lockFile;
    private final File versionFile;

    public BackendJobBase(IConfigService.Module module) {
        this.lockFile = Services.get(IConfigService.class).getLockFilePath(module);
        this.versionFile = Services.get(IConfigService.class).getVersionFilePath();
    }

    @Override
    public File getLockFile() {
        return this.lockFile;
    }

    @Override
    public boolean needsLocking() {
        return true;
    }

    @Override
    public File getVersionFile() {
        return this.versionFile;
    }

    protected void log(Throwable t, String ... message) {
        Services.get(ILoggingService.class).logAndReport(t, message);
    }

    protected void writeMasterData(IDataNode<?> data) throws Exception {
        XMLWriter writer = new XMLWriter();
        File path = JobUtil.getMasterDataPath(data.getDataFileType(), false);
        writer.write(path, data, true);
    }

    @Override
    public boolean showWaitCursor() {
        return false;
    }

    @Override
    public boolean skipAfterShutdown() {
        return false;
    }

    @Override
    public boolean isInterruptible() {
        return false;
    }
}

