/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.service.config;

import ch.transsoft.expovit.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class FileEnvironment {
    public static final String EXPOVIT = "expovit";
    public static final String EXAMPLE_CONTENT = "Passar-ExampleContent";
    public static final String LEGACY_EXAMPLE_CONTENT = "ExampleContent";
    private static boolean useRoamingDir;

    private static File getRoamingDir() {
        String profile = System.getenv("APPDATA");
        if (profile == null) {
            return null;
        }
        return new File(profile);
    }

    public static File getLocalConfigDir() {
        if (useRoamingDir) {
            return new File(FileEnvironment.getRoamingDir(), EXPOVIT);
        }
        return FileEnvironment.getOldLocalConfigDir();
    }

    public static File getPreferencesDir() {
        return FileEnvironment.getLocalConfigDir();
    }

    private static File getOldLocalConfigDir() {
        File result = new File(FileEnvironment.getUserHome(), EXPOVIT);
        FileUtil.bestEffortMkdirs(result);
        return result;
    }

    private static File getUserHome() {
        File home = new File(System.getProperty("user.home"));
        if (home.exists()) {
            return home;
        }
        return new File(System.getenv("USERPROFILE"));
    }

    public static File getDefaultRootDir() {
        return new File(FileEnvironment.getLocalConfigDir(), EXAMPLE_CONTENT);
    }

    public static File getLegacyDefaultRootDir() {
        return new File(FileEnvironment.getLocalConfigDir(), LEGACY_EXAMPLE_CONTENT);
    }

    private static void setLocalConfigDir() {
        File newDir = FileEnvironment.getRoamingDir();
        if (newDir == null) {
            useRoamingDir = false;
            return;
        }
        File newExpovitDir = new File(newDir, EXPOVIT);
        if (newExpovitDir.exists()) {
            useRoamingDir = true;
            return;
        }
        try {
            useRoamingDir = FileEnvironment.migrateLocalConfigDir(newExpovitDir);
        }
        catch (Exception e) {
            useRoamingDir = false;
        }
    }

    private static boolean migrateLocalConfigDir(File newExpovitDir) throws IOException {
        if (!FileUtil.bestEffortMkdirs(newExpovitDir)) {
            return false;
        }
        if (FileEnvironment.getOldLocalConfigDir().getCanonicalPath().equals(newExpovitDir.getCanonicalPath())) {
            return false;
        }
        FileUtil.recursiveCopy(FileEnvironment.getOldLocalConfigDir(), newExpovitDir);
        return true;
    }

    static {
        FileEnvironment.setLocalConfigDir();
    }
}

