/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.dialog;

import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.gui.IGuiService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class DialogUtil {
    public static void showErrorDialog(String title, String text) {
        JOptionPane.showMessageDialog(null, text, title, 0);
    }

    public static void showWarningDialog(String title, String text) {
        JOptionPane.showMessageDialog(null, text, title, 2);
    }

    public static void showInfoDialog(String title, String text) {
        JOptionPane.showMessageDialog(null, text, title, 1);
    }

    public static int showDeleteDialogt(String message, String title) {
        return DialogUtil.showDeleteDialogt(Services.get(IGuiService.class).getMainFrame(), message, title);
    }

    public static int showDeleteDialogt(Component parent, String message, String title) {
        String[] options = new String[]{Services.getText("210"), Services.getText("208")};
        return DialogUtil.showDialog(2, parent, message, title, options);
    }

    public static int showOverwriteDialogt(Component parent, String message, String title) {
        String[] options = new String[]{Services.getText("211"), Services.getText("208")};
        return DialogUtil.showDialog(3, parent, message, title, options);
    }

    public static int showSaveDialogt(Component parent, String message, String title) {
        String[] options = new String[]{Services.getText("201"), Services.getText("206")};
        return DialogUtil.showDialog(3, parent, message, title, options);
    }

    private static int showDialog(int messateType, Component parent, String message, String title, String[] options) {
        return JOptionPane.showOptionDialog(parent, message, title, 0, messateType, null, options, options[0]);
    }

    public static void centerDialog(Window dialog, int width, int height) {
        Rectangle b = dialog.getOwner().getBounds();
        DialogUtil.centerDialog(dialog, width, height, b);
    }

    public static void centerDialog(Window dialog, int width, int height, Rectangle b) {
        int x = b.x + (b.width - width) / 2;
        int y = b.y + (b.height - height) / 2;
        dialog.setBounds(x, y, width, height);
    }

    public static boolean showYesNoDialog(String message, String title) {
        String[] options = new String[]{Services.getText("213"), Services.getText("214")};
        JFrame parent = Services.get(IGuiService.class).getMainFrame();
        return DialogUtil.showDialog(3, parent, message, title, options) == 0;
    }

    public static Answer showDialog(Window windowAncestor, int messageType, String title, String message, String ... options) {
        int result = JOptionPane.showOptionDialog(windowAncestor, message, title, options.length == 3 ? 1 : 0, messageType, null, options, options[0]);
        if (result == 0) {
            return Answer.yes;
        }
        if (result == 1) {
            return Answer.no;
        }
        return Answer.cancel;
    }

    public static String getInput(String msg, String title) {
        return JOptionPane.showInputDialog(null, msg, title, -1);
    }

    public static void showBigText(Window parent, String title, String text) {
        BigTextDialog dialog = new BigTextDialog(parent, title, text);
        DialogUtil.centerDialog(dialog, 800, 700);
        dialog.setVisible(true);
    }

    public static enum Answer {
        yes,
        no,
        cancel;

    }

    private static class BigTextDialog
    extends JDialog {
        public BigTextDialog(Window parent, String title, String bigText) {
            super(parent, title);
            this.setLayout(new BorderLayout());
            JScrollPane text = new JScrollPane(new JTextArea(bigText));
            this.add(text);
        }
    }
}

