/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.dialog.option.gui;

import ch.transsoft.expovit.model.config.conf.options.ProxyAuth;
import ch.transsoft.expovit.model.config.conf.options.ProxyType;
import ch.transsoft.expovit.ui.dialog.option.gui.ProxyAuthItem;
import ch.transsoft.expovit.ui.dialog.option.pm.IProxyResponsiveItem;
import ch.transsoft.expovit.ui.dialog.option.pm.OptionDialogProxyPm;
import ch.transsoft.expovit.ui.dialog.option.pm.ProxyHostItem;
import ch.transsoft.expovit.ui.dialog.option.pm.SystemProxyItem;
import ch.transsoft.expovit.ui.gui.control.DefaultPanel;
import ch.transsoft.expovit.util.ui.disclosure.ResponsiveDisclosure;
import ch.transsoft.expovit.util.ui.enablement.ResponsiveEnablement;
import java.awt.Component;
import net.miginfocom.swing.MigLayout;

public final class OptionProxyHostPanel
extends DefaultPanel {
    private final OptionDialogProxyPm pm;

    public OptionProxyHostPanel(OptionDialogProxyPm pm) {
        this.pm = pm;
        this.setLayout(new MigLayout("", "[]", "[][]"));
        this.add((Component)this.createProxySelection(), "wrap");
        this.add(this.createProxyAuthentication());
    }

    private ResponsiveDisclosure createProxySelection() {
        ResponsiveDisclosure responsiveDisclosure = new ResponsiveDisclosure();
        SystemProxyItem systemProxyItem = new SystemProxyItem();
        responsiveDisclosure.addItem(systemProxyItem);
        ProxyHostItem proxyHostItem = new ProxyHostItem(this.pm);
        responsiveDisclosure.addItem(proxyHostItem);
        responsiveDisclosure.setSelectedItem(this.pm.getSelectedProxyType() == ProxyType.systemProxy ? systemProxyItem : proxyHostItem);
        responsiveDisclosure.addListener(selectedValue -> this.pm.setSelectedProxyType(((IProxyResponsiveItem)selectedValue).getProxyType()));
        return responsiveDisclosure;
    }

    private ResponsiveEnablement createProxyAuthentication() {
        ProxyAuth proxyAuth = this.pm.getProxyInfo().getProxyAuth();
        ResponsiveEnablement responsiveEnablement = new ResponsiveEnablement(new ProxyAuthItem(this.pm.getAuthPm()), proxyAuth.isEnabled());
        responsiveEnablement.addListener(proxyAuth::setEnabled);
        return responsiveEnablement;
    }
}

