/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.ui.dialog.trust.pm;

import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public record CertificateInfo(ParsedPrincipal subject, ParsedPrincipal issuer, Date validFrom, Date validUntil, String serialNumber, String sha256Fingerprint, String sha1Fingerprint, boolean isExpired, boolean isNotYetValid) {
    public static CertificateInfo fromCertificate(X509Certificate certificate) {
        return new CertificateInfo(ParsedPrincipal.parse(certificate.getSubjectX500Principal().getName()), ParsedPrincipal.parse(certificate.getIssuerX500Principal().getName()), certificate.getNotBefore(), certificate.getNotAfter(), certificate.getSerialNumber().toString(16).toUpperCase(), CertificateInfo.getFingerprint(certificate, "SHA-256"), CertificateInfo.getFingerprint(certificate, "SHA-1"), certificate.getNotAfter().before(new Date()), certificate.getNotBefore().after(new Date()));
    }

    private static String getFingerprint(X509Certificate certificate, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] fingerprint = digest.digest(certificate.getEncoded());
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < fingerprint.length; ++i) {
                builder.append(String.format("%02x", fingerprint[i]));
                if (i >= fingerprint.length - 1) continue;
                builder.append(":");
            }
            return builder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public record ParsedPrincipal(String commonName, String organisation, String country) {
        private static final String CN = "CN=";
        private static final String O = "O=";
        private static final String C = "C=";

        public static ParsedPrincipal parse(String parsed) {
            String commonName = "-";
            String organisation = "-";
            String country = "-";
            List<String> parts = Arrays.stream(parsed.split(",")).map(String::trim).toList();
            for (String part : parts) {
                if (part.startsWith(CN)) {
                    commonName = part.substring(CN.length());
                    continue;
                }
                if (part.startsWith(O)) {
                    organisation = part.substring(O.length());
                    continue;
                }
                if (!part.startsWith(C)) continue;
                country = part.substring(C.length());
            }
            return new ParsedPrincipal(commonName, organisation, country);
        }
    }
}

