/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.expovit.util;

import ch.transsoft.expovit.util.Check;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class GuiUtil {
    public static BufferedImage loadImage(GraphicsConfiguration graphicsConfiguration, InputStream inputStream) {
        try {
            BufferedImage raw = ImageIO.read(inputStream);
            BufferedImage result = graphicsConfiguration.createCompatibleImage(raw.getWidth(), raw.getHeight());
            result.getGraphics().create().drawImage(raw, 0, 0, null);
            return result;
        }
        catch (IOException e) {
            throw Check.fail(e);
        }
    }

    public static void setEnabled(Container container, boolean enable) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component current = container.getComponent(i);
            current.setEnabled(enable);
            if (!(current instanceof Container)) continue;
            GuiUtil.setEnabled((Container)current, enable);
        }
    }

    public static Window getWindowAncestor(AWTEvent e) {
        Container parent;
        if (e.getSource() == null || !(e.getSource() instanceof Component)) {
            throw new IllegalArgumentException("Source is null or not of type Component");
        }
        Component source = (Component)e.getSource();
        Window windowAncestor = SwingUtilities.getWindowAncestor(source);
        if (windowAncestor == null && source instanceof JMenuItem && (parent = source.getParent()) instanceof JPopupMenu) {
            return SwingUtilities.getWindowAncestor(((JPopupMenu)parent).getInvoker());
        }
        return windowAncestor;
    }

    public static void closeDialog(ActionEvent e) {
        GuiUtil.closeDialog(GuiUtil.getWindowAncestor(e));
    }

    public static void closeDialog(Window dialog) {
        dialog.dispatchEvent(new WindowEvent(dialog, 201));
    }

    public static void addEscapeAction(JRootPane rootPane, Action escapeAction) {
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        rootPane.getActionMap().put("ESCAPE", escapeAction);
    }

    public static void addEscapeAction(JRootPane rootPane) {
        GuiUtil.addEscapeAction(rootPane, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiUtil.getWindowAncestor(e).dispose();
            }
        });
    }
}

