/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher.configuration;

import ch.transsoft.expovit.service.Services;
import ch.transsoft.expovit.service.logging.ILoggingService;
import ch.transsoft.launcher.JnlpFile;
import ch.transsoft.launcher.JnlpJarNativeLib;
import ch.transsoft.launcher.JnlpJre;
import ch.transsoft.launcher.JnlpResource;
import ch.transsoft.launcher.configuration.Application;
import ch.transsoft.launcher.configuration.LaunchConfiguration;
import ch.transsoft.launcher.download.FileResource;
import ch.transsoft.launcher.util.JavaProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0006\u0010\u0016\u001a\u00020\u0017J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lch/transsoft/launcher/configuration/JnlpLaunchConfiguration;", "Lch/transsoft/launcher/configuration/LaunchConfiguration;", "jnlpFile", "Lch/transsoft/launcher/JnlpFile;", "resources", "", "Lch/transsoft/launcher/JnlpResource;", "Lch/transsoft/launcher/download/FileResource;", "<init>", "(Lch/transsoft/launcher/JnlpFile;Ljava/util/Map;)V", "mainJar", "getMainJar", "()Lch/transsoft/launcher/JnlpResource;", "mainJarFile", "getMainJarFile", "()Lch/transsoft/launcher/download/FileResource;", "getClasspath", "", "getNativeLibArgument", "getMissingFiles", "", "Ljava/io/File;", "checkJavaVersion", "", "getJreCommandLineArgs", "", "Companion", "launcher"})
@SourceDebugExtension(value={"SMAP\nJnlpLaunchConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JnlpLaunchConfiguration.kt\nch/transsoft/launcher/configuration/JnlpLaunchConfiguration\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n536#2:84\n521#2,6:85\n126#3:91\n153#3,3:92\n1563#4:95\n1634#4,3:96\n774#4:99\n865#4,2:100\n*S KotlinDebug\n*F\n+ 1 JnlpLaunchConfiguration.kt\nch/transsoft/launcher/configuration/JnlpLaunchConfiguration\n*L\n49#1:84\n49#1:85,6\n50#1:91\n50#1:92,3\n56#1:95\n56#1:96,3\n57#1:99\n57#1:100,2\n*E\n"})
public final class JnlpLaunchConfiguration
implements LaunchConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JnlpFile jnlpFile;
    @NotNull
    private final Map<JnlpResource, FileResource> resources;

    public JnlpLaunchConfiguration(@NotNull JnlpFile jnlpFile, @NotNull Map<JnlpResource, ? extends FileResource> resources) {
        Intrinsics.checkNotNullParameter(jnlpFile, "jnlpFile");
        Intrinsics.checkNotNullParameter(resources, "resources");
        this.jnlpFile = jnlpFile;
        this.resources = resources;
    }

    private final JnlpResource getMainJar() {
        return this.jnlpFile.getMainJar();
    }

    @NotNull
    public final FileResource getMainJarFile() {
        return MapsKt.getValue(this.resources, this.getMainJar());
    }

    @NotNull
    public final String getClasspath() {
        Sequence<FileResource> sequence = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.resources.entrySet()), JnlpLaunchConfiguration::getClasspath$lambda$0), JnlpLaunchConfiguration::getClasspath$lambda$1);
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue(string, "pathSeparator");
        return SequencesKt.joinToString$default(sequence, string, null, null, 0, null, JnlpLaunchConfiguration::getClasspath$lambda$2, 30, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getNativeLibArgument() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map<JnlpResource, FileResource> $this$filter$iv = this.resources;
        boolean $i$f$filter = false;
        Map<JnlpResource, FileResource> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(it.getKey() instanceof JnlpJarNativeLib)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add(((FileResource)it.getValue()).getZipDirectory().getAbsolutePath());
        }
        Iterable iterable = (List)destination$iv$iv;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue(string, "pathSeparator");
        return CollectionsKt.joinToString$default(iterable, string, null, null, 0, null, null, 62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getMissingFiles() {
        void $this$filterTo$iv$iv;
        File it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.resources.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((FileResource)it.getValue()).getFile());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (File)element$iv$iv;
            boolean bl = false;
            if (!(!it.exists())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    public final void checkJavaVersion() {
        Runtime.Version version;
        JnlpJre jre = this.jnlpFile.getJre();
        Runtime.Version javaVersion = Runtime.Version.parse(JavaProperties.INSTANCE.getJavaVersion());
        try {
            String string = jre.getVersionString();
            Intrinsics.checkNotNullExpressionValue(string, "<get-versionString>(...)");
            version = Runtime.Version.parse(StringsKt.replace$default(string, "corretto-", "", false, 4, null));
        }
        catch (Exception e) {
            String[] stringArray = new String[]{"Illegal syntax for JRE version in JNLP"};
            Services.get(ILoggingService.class).logSilent(e, stringArray);
            version = javaVersion;
        }
        Runtime.Version jnlpVersion = version;
        if (javaVersion.feature() < jnlpVersion.feature() || javaVersion.interim() < jnlpVersion.interim()) {
            throw new RuntimeException("Update Launcher: Java version string not matching. Current Java Version is: " + javaVersion + ", specified is " + jnlpVersion);
        }
    }

    @NotNull
    public final List<String> getJreCommandLineArgs() {
        if (StringsKt.isBlank(this.jnlpFile.getJre().getCommandLineArgs())) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = new String[]{" "};
        return StringsKt.split$default((CharSequence)this.jnlpFile.getJre().getCommandLineArgs(), stringArray, false, 0, 6, null);
    }

    private static final boolean getClasspath$lambda$0(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !(it.getKey() instanceof JnlpJarNativeLib);
    }

    private static final FileResource getClasspath$lambda$1(Map.Entry it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (FileResource)it.getValue();
    }

    private static final CharSequence getClasspath$lambda$2(FileResource downloadedResource) {
        Intrinsics.checkNotNullParameter(downloadedResource, "downloadedResource");
        String string = downloadedResource.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue(string, "getAbsolutePath(...)");
        return string;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lch/transsoft/launcher/configuration/JnlpLaunchConfiguration$Companion;", "", "<init>", "()V", "compileLocalConfiguration", "Lch/transsoft/launcher/configuration/JnlpLaunchConfiguration;", "application", "Lch/transsoft/launcher/configuration/Application;", "targetDirectory", "Ljava/io/File;", "launcher"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JnlpLaunchConfiguration compileLocalConfiguration(@NotNull Application application, @NotNull File targetDirectory) {
            Intrinsics.checkNotNullParameter((Object)application, "application");
            Intrinsics.checkNotNullParameter(targetDirectory, "targetDirectory");
            JnlpFile jnlp = JnlpFile.Companion.readJnlpFile(FilesKt.resolve(targetDirectory, application.getJnlpName()));
            Map resources = MapsKt.toMap(SequencesKt.map(jnlp.getDownloadableResources(), arg_0 -> Companion.compileLocalConfiguration$lambda$0(targetDirectory, arg_0)));
            return new JnlpLaunchConfiguration(jnlp, resources);
        }

        private static final Pair compileLocalConfiguration$lambda$0(File $targetDirectory, JnlpResource it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return TuplesKt.to(it, new FileResource(it.toLocalFilePath($targetDirectory), it.getUnzipRequired()));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

