/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher.download;

import ch.transsoft.launcher.configuration.Application;
import ch.transsoft.launcher.download.Environment;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000f\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lch/transsoft/launcher/download/ApplicationSettings;", "", "<init>", "()V", "properties", "Ljava/util/Properties;", "value", "Lch/transsoft/launcher/configuration/Application;", "lastLaunchedApplication", "getLastLaunchedApplication", "()Lch/transsoft/launcher/configuration/Application;", "setLastLaunchedApplication", "(Lch/transsoft/launcher/configuration/Application;)V", "save", "", "Companion", "SettingsKey", "launcher"})
public final class ApplicationSettings {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Properties properties = new Properties();
    @NotNull
    private static final String APPLICATION_SETTINGS = "application.settings";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationSettings() {
        File settingsFile = FilesKt.resolve(Environment.INSTANCE.getWorkingDirectory(), APPLICATION_SETTINGS);
        if (settingsFile.exists()) {
            Closeable closeable = new FileInputStream(settingsFile);
            Throwable throwable = null;
            try {
                FileInputStream it = (FileInputStream)closeable;
                boolean bl = false;
                this.properties.load(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
    }

    @NotNull
    public final Application getLastLaunchedApplication() {
        Object applicationName = this.properties.getOrDefault((Object)"last", ((Application)((Object)Application.getEntries().get(0))).name());
        return Application.valueOf(applicationName.toString());
    }

    public final void setLastLaunchedApplication(@NotNull Application value) {
        Intrinsics.checkNotNullParameter((Object)value, "value");
        ((Map)this.properties).put("last", value.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        File workingDirectory = Environment.INSTANCE.getWorkingDirectory();
        workingDirectory.mkdirs();
        File file = FilesKt.resolve(workingDirectory, APPLICATION_SETTINGS);
        Closeable closeable = new FileOutputStream(file);
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl = false;
            this.properties.store(it, "ExpoVit Launcher Configuration");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lch/transsoft/launcher/download/ApplicationSettings$Companion;", "", "<init>", "()V", "APPLICATION_SETTINGS", "", "launcher"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lch/transsoft/launcher/download/ApplicationSettings$SettingsKey;", "", "<init>", "()V", "LAST_LAUNCHED_APPLICATION", "", "launcher"})
    private static final class SettingsKey {
        @NotNull
        public static final SettingsKey INSTANCE = new SettingsKey();
        @NotNull
        public static final String LAST_LAUNCHED_APPLICATION = "last";

        private SettingsKey() {
        }
    }
}

