/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher.download;

import ch.transsoft.launcher.download.FileResource;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lch/transsoft/launcher/download/DownloadResource;", "Lch/transsoft/launcher/download/FileResource;", "file", "Ljava/io/File;", "url", "", "fileSize", "", "unzipRequired", "", "<init>", "(Ljava/io/File;Ljava/lang/String;JZ)V", "getUrl", "()Ljava/lang/String;", "getFileSize", "()J", "tempFile", "getTempFile", "()Ljava/io/File;", "fileValid", "getFileValid", "()Z", "needsDownload", "getNeedsDownload", "tempFileValid", "getTempFileValid", "launcher"})
public final class DownloadResource
extends FileResource {
    @NotNull
    private final String url;
    private final long fileSize;
    @NotNull
    private final File tempFile;
    private final boolean fileValid;
    private final boolean needsDownload;
    private final boolean tempFileValid;

    public DownloadResource(@NotNull File file, @NotNull String url2, long fileSize, boolean unzipRequired) {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(url2, "url");
        super(file, unzipRequired);
        this.url = url2;
        this.fileSize = fileSize;
        this.tempFile = new File(file.getParent(), "_" + file.getName());
        this.fileValid = file.exists() && file.length() == this.fileSize;
        this.needsDownload = !this.fileValid;
        this.tempFileValid = this.tempFile.exists() && this.tempFile.length() == this.fileSize;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final long getFileSize() {
        return this.fileSize;
    }

    @NotNull
    public final File getTempFile() {
        return this.tempFile;
    }

    public final boolean getFileValid() {
        return this.fileValid;
    }

    public final boolean getNeedsDownload() {
        return this.needsDownload;
    }

    public final boolean getTempFileValid() {
        return this.tempFileValid;
    }
}

