/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.launcher.download;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lch/transsoft/launcher/download/FileResource;", "", "file", "Ljava/io/File;", "unzipRequired", "", "<init>", "(Ljava/io/File;Z)V", "getFile", "()Ljava/io/File;", "getUnzipRequired", "()Z", "getZipDirectory", "launcher"})
public class FileResource {
    @NotNull
    private final File file;
    private final boolean unzipRequired;

    public FileResource(@NotNull File file, boolean unzipRequired) {
        Intrinsics.checkNotNullParameter(file, "file");
        this.file = file;
        this.unzipRequired = unzipRequired;
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    public final boolean getUnzipRequired() {
        return this.unzipRequired;
    }

    @NotNull
    public final File getZipDirectory() {
        File file = this.file.getParentFile();
        Intrinsics.checkNotNullExpressionValue(file, "getParentFile(...)");
        return FilesKt.resolve(file, FilesKt.getNameWithoutExtension(this.file));
    }
}

