/*
 * Decompiled with CFR 0.152.
 */
package nl.altindag.ssl.keymanager;

import java.util.Collections;
import java.util.Map;
import javax.net.ssl.X509ExtendedKeyManager;
import nl.altindag.ssl.keymanager.AggregatedX509ExtendedKeyManager;
import nl.altindag.ssl.keymanager.HotSwappableX509ExtendedKeyManager;
import nl.altindag.ssl.util.KeyManagerUtils;

public class InflatableX509ExtendedKeyManager
extends HotSwappableX509ExtendedKeyManager {
    public InflatableX509ExtendedKeyManager() {
        this("dummy", KeyManagerUtils.createDummyKeyManager());
    }

    public InflatableX509ExtendedKeyManager(String alias, X509ExtendedKeyManager keyManager) {
        super(keyManager instanceof AggregatedX509ExtendedKeyManager ? keyManager : new AggregatedX509ExtendedKeyManager(Collections.singletonMap(alias, keyManager)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(String alias, X509ExtendedKeyManager keyManager) {
        this.writeLock.lock();
        try {
            AggregatedX509ExtendedKeyManager aggregatedKeyManager = (AggregatedX509ExtendedKeyManager)this.getInnerKeyManager();
            aggregatedKeyManager.keyManagers.remove("dummy");
            aggregatedKeyManager.keyManagers.put(alias, keyManager);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeIdentity(String alias) {
        this.writeLock.lock();
        try {
            ((AggregatedX509ExtendedKeyManager)this.getInnerKeyManager()).keyManagers.remove(alias);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Map<String, X509ExtendedKeyManager> getAliasToIdentity() {
        this.readLock.lock();
        try {
            Map<String, X509ExtendedKeyManager> map2 = Collections.unmodifiableMap(((AggregatedX509ExtendedKeyManager)this.getInnerKeyManager()).keyManagers);
            return map2;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

