/*
 * Decompiled with CFR 0.152.
 */
package ch.transsoft.bootstrap;

import ch.transsoft.bootstrap.Environment;
import ch.transsoft.bootstrap.util.Const;
import ch.transsoft.bootstrap.util.LauncherFileName;
import ch.transsoft.bootstrap.util.Logging;
import ch.transsoft.bootstrap.util.VersionProvider;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Main {
    static final String LAUNCHER_MAIN_CLASS = "ch.transsoft.launcher.MainJava";
    static final String LAUNCHER_MAIN_METHOD = "main";
    static final String BOOTSTRAP_VERSION_PROPERTY = "bootstrap.version";
    static final String BOOTSTRAP_JAR_FILE_PROPERTY = "bootstrap.jarFile";
    static final String LAUNCHER_BINARY_NAME_PROPERTY = "launcher.binaryName";

    public static void main(String[] args) {
        Path jarToUse;
        Logger logger = Logging.getLogger();
        logger.log(Level.INFO, "Bootstrap started");
        Path installedJar = Main.findLatestLauncherJar(Environment.getJarPath().getParent());
        Path downloadedJar = Main.findLatestLauncherJar(Environment.getDownloadedJarDirectory());
        if (downloadedJar == null && installedJar == null) {
            Main.abortWithDialog("Could not find launcher jar in launcher installation path and downloaded directory. \n\nDownload directory: " + Const.singleQuoted(Environment.getDownloadedJarDirectory()) + "\nLauncher installation path: " + Const.singleQuoted(Environment.getInstalledJarDir()));
            return;
        }
        if (downloadedJar == null) {
            jarToUse = installedJar;
            logger.log(Level.INFO, "Using launcher jar from launcher installation path, because no jar in downloaded jar folder: " + Const.singleQuoted(Environment.getDownloadedJarDirectory()));
        } else if (installedJar != null && Main.isInstalledJarNewer(downloadedJar, installedJar)) {
            jarToUse = installedJar;
            logger.log(Level.INFO, "Using launcher jar from launcher installation path, because downloaded version is older. Downloaded jar: " + Const.singleQuoted(downloadedJar));
        } else {
            jarToUse = downloadedJar;
            logger.log(Level.INFO, "Using launcher jar from download directory: " + Const.singleQuoted(downloadedJar));
        }
        try {
            URLClassLoader classLoader = new URLClassLoader(new URL[]{jarToUse.toUri().toURL()}, null);
            Class<?> clazz = Class.forName(LAUNCHER_MAIN_CLASS, true, classLoader);
            Method method = clazz.getMethod(LAUNCHER_MAIN_METHOD, String[].class);
            System.setProperty(LAUNCHER_BINARY_NAME_PROPERTY, Environment.getProcessCommandOrEmpty());
            System.setProperty(BOOTSTRAP_VERSION_PROPERTY, VersionProvider.getVersion());
            System.setProperty(BOOTSTRAP_JAR_FILE_PROPERTY, Environment.getJarPathOrEmpty());
            method.invoke(null, new Object[]{args});
            logger.log(Level.INFO, "Launcher invoked successfully via classloader using jar: " + Const.singleQuoted(jarToUse));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            Main.abortWithDialog("Could not instantiate launcher main-class from jar:\n" + Const.singleQuoted(jarToUse) + "\n\nError message:\n" + e.getMessage());
        }
    }

    private static boolean isInstalledJarNewer(@NotNull Path downloadedJar, @NotNull Path installedJar) {
        LauncherFileName downloaded = new LauncherFileName(downloadedJar.toFile());
        LauncherFileName installed = new LauncherFileName(installedJar.toFile());
        return downloaded.isSmaller(installed);
    }

    private static void abortWithDialog(String message) {
        Logging.getLogger().log(Level.SEVERE, message);
        JOptionPane.showMessageDialog(null, message);
        System.exit(1);
    }

    @Nullable
    private static Path findLatestLauncherJar(@Nullable Path directory) {
        if (directory == null) {
            return null;
        }
        File[] files = directory.toFile().listFiles((dir, name) -> name.startsWith("launcher-all") && name.endsWith(".jar"));
        if (files == null || files.length == 0) {
            return null;
        }
        return Arrays.stream(files).filter(file -> !file.getName().equalsIgnoreCase("launcher-all.jar")).map(LauncherFileName::new).filter(LauncherFileName::isValid).max(Comparator.naturalOrder()).map(it -> it.getFile().toPath()).orElse(null);
    }
}

